package com.artfess.gyl.utils;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.file.util.MinioUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;

@Service
public class MinioUtils {
    @Async
    public void startMinIOUpload(File file, String bizPath, String name) throws Exception {
        String result = MinioUtil.upload((MultipartFile) file, bizPath, name, "gyl");
        // MinIO上传成功后删除服务端缓存
        if(!StringUtils.isEmpty(result)){
            FileUtil.deleteDir(file.getParentFile());
        }
    }

    @Async
    public void startMinIOUpload(File file, String bizPath, String name,String bucketName) throws Exception {
        String result = MinioUtil.upload((MultipartFile) file, bizPath, name, bucketName);
        // MinIO上传成功后删除服务端缓存
        if(!StringUtils.isEmpty(result)){
            FileUtil.deleteDir(file.getParentFile());
        }
    }

    //    @Async
    public void startMinIOUpload(MultipartFile file, String bizPath, String name) throws Exception {
        String result = MinioUtil.upload(file, bizPath, name, "cgpt");
        // MinIO上传成功后删除服务端缓存
        if(!StringUtils.isEmpty(result)){
//            File fl = new File("C://");
//            FileUtils.copyInputStreamToFile(file.getInputStream(), fl);
            // 获取文件名
            String fileName = file.getOriginalFilename();
            // 获取文件后缀
            String prefix = fileName.substring(fileName.lastIndexOf("."));
            try {
                File data = File.createTempFile(fileName, prefix);
                file.transferTo(data);
                FileUtil.deleteDir(data);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    //    @Async
    public void startMinIOUpload(MultipartFile file, String bizPath, String name,String bucketName) throws Exception {
        String result = MinioUtil.upload(file, bizPath, name, BeanUtils.isNotEmpty(bucketName)?bucketName:"cgpt");
        // MinIO上传成功后删除服务端缓存
        if(!StringUtils.isEmpty(result)){
//            File fl = new File("C://");
//            FileUtils.copyInputStreamToFile(file.getInputStream(), fl);
            // 获取文件名
            String fileName = file.getOriginalFilename();
            // 获取文件后缀
            String prefix = fileName.substring(fileName.lastIndexOf("."));
            try {
                File data = File.createTempFile(fileName, prefix);
                file.transferTo(data);
                FileUtil.deleteDir(data);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 获取服务器存放文件的目录路径
     * @return 目录路径（String)
     */
    public String getFileDir(String subDir){
        String path= ClassUtils.getDefaultClassLoader().
                getResource("").getPath().substring(1)+"static/uploadingFileTemp/"+subDir.split("[.]")[0];
        System.out.println("*********************"+path);
        File dir=new File(path);
        if(!dir.exists()){
            dir.mkdirs();
        }
        return path;
    }


    /**
     * 获取服务器存放文件的目录路径
     * @return 目录路径（String)
     */
    public String getofficeToPdfTempDir(String subDir){
        String path= ClassUtils.getDefaultClassLoader().
                getResource("").getPath().substring(1)+"static/officeToPdfTemp/"+subDir.split("[.]")[0];
        File dir=new File(path);
        if(!dir.exists()){
            dir.mkdirs();
        }
        return path;
    }
}
