package com.artfess.gyl.thirdParty.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业管理表
 *
 * @author 管理员
 * @since 2025-11-08
 */
@Data
@TableName("biz_enterprise")
@ApiModel(value="BizEnterprise对象", description="企业管理表")
public class BizEnterprise extends BizDelModel<BizEnterprise> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "组织ID（关联组织表ID）")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "企业编号（关联组织表编号）")
    @TableField("COMPANY_CODE_")
    private String companyCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "组织编号（税号）")
    @TableField("COMPANY_ORGCODE_")
    private String companyOrgcode;

    @ApiModelProperty(value = "法人")
    @TableField("COMPANY_EBE_")
    private String companyEbe;

    @ApiModelProperty(value = "注册日期")
    @TableField("COMPANY_REGDATE_")
    private LocalDate companyRegdate;

    @ApiModelProperty(value = "注册有效期至")
    @TableField("COMPANY_REGDATE_END_")
    private String companyRegdateEnd;

    @ApiModelProperty(value = "省份")
    @TableField("PROVINCE_")
    private String province;

    @ApiModelProperty(value = "城市")
    @TableField("CITY_")
    private String city;

    @ApiModelProperty(value = "区县")
    @TableField("COUNTY_")
    private String county;

    @ApiModelProperty(value = "企业地址")
    @TableField("COMPANY_ADDR_")
    private String companyAddr;

    @ApiModelProperty(value = "联系人")
    @TableField("COMPANY_CONTACT_")
    private String companyContact;

    @ApiModelProperty(value = "联系电话")
    @TableField("CONTACT_TEL_")
    private String contactTel;

    @ApiModelProperty(value = "企业类型")
    @TableField("OWNER_TYPE_")
    private String ownerType;

    @ApiModelProperty(value = "注册资金(万元)")
    @TableField("REGISTERED_CAPITAL_")
    private Double registeredCapital;

    @ApiModelProperty(value = "注册资金类型（1.人民币，2.美元，3.英镑，4.日元，5.港币）")
    @TableField("REGISTERED_CAPITAL_TYPE_")
    private Integer registeredCapitalType;

    @ApiModelProperty(value = "邮箱")
    @TableField("MAIL_")
    private String mail;

    @ApiModelProperty(value = "邮政编码")
    @TableField("POST_CODE_")
    private String postCode;

    @ApiModelProperty(value = "统一社会信用代码")
    @TableField("CREDIT_CODE_")
    private String creditCode;

    @ApiModelProperty(value = "联行号")
    @TableField("INTERBANK_")
    private String interbank;

    @ApiModelProperty(value = "银行账号")
    @TableField("BANK_")
    private String bank;

    @ApiModelProperty(value = "开户银行")
    @TableField("OPENING_BANK_")
    private String openingBank;

    @ApiModelProperty(value = "邮寄地址")
    @TableField("MAILING_ADDRESS_")
    private String mailingAddress;

    @ApiModelProperty(value = "纳税人类型（1:一般纳税人，2:小规模纳税人，3:个人，默认1）")
    @TableField("TAXPAYER_TYPE_")
    private Integer taxpayerType;

    @ApiModelProperty(value = "历史企业编号对应浪潮")
    @TableField("HISTORY_COMPANY_CODE_")
    private String historyCompanyCode;

    @ApiModelProperty(value = "注册类型（0：企业，1：个人，默认0）")
    @TableField("REGIS_TYPE_")
    private Integer regisType;

    @ApiModelProperty(value = "行业分类编号（关联国民经济行业分类表编号）")
    @TableField("INDUSTRY_CODE_")
    private String industryCode;

    @ApiModelProperty(value = "行业分类名称（关联国民经济行业分类表名称）")
    @TableField("INDUSTRY_NAME_")
    private String industryName;


}
