package com.artfess.gyl.thirdParty.manager.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.artfess.gyl.thirdParty.dao.BizEnterpriseDao;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 企业管理表 服务实现类
 *
 * @author 管理员
 * @since 2025-11-08
 */
@Service
public class BizEnterpriseManagerImpl extends BaseManagerImpl<BizEnterpriseDao, BizEnterprise> implements BizEnterpriseManager {

    @Override
    public BizEnterprise getByOrgIdOrCode(String orgId, String orgCode) {
        LambdaQueryWrapper<BizEnterprise> enterpriseQW = new LambdaQueryWrapper<>();
        enterpriseQW.and(q -> q.eq(BizEnterprise::getOrgId, orgId).or()
                        .eq(BizEnterprise::getCompanyCode, orgCode))
                .eq(BizEnterprise::getIsDele, "0")
                .orderByDesc(BizEnterprise::getCreateTime).last("limit 1");
        return baseMapper.selectOne(enterpriseQW);
    }



}

