package com.artfess.gyl.thirdParty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.thirdParty.vo.CategoryNumVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.thirdParty.model.BizCategory;
import com.artfess.gyl.thirdParty.manager.BizCategoryManager;

import java.util.List;

/**
 *  前端控制器
 *
 * @author 系统管理员
 * @since 2025-11-10
 */
@RestController
@RequestMapping("/bizCategory/v1/")
@Api(tags = "第三方数据-平台物料分类")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizCategoryController extends BaseController<BizCategoryManager, BizCategory> {

    @PostMapping(value="/tree", produces={"application/json; charset=utf-8" })
    @ApiOperation("按分类查询")
    public CommonResult queryPermission(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizCategory> queryFilter) {
        queryFilter.setPageBean(new PageBean(1,-1));
        List<BizCategory> tree = baseService.tree(queryFilter);
        return CommonResult.success(tree,"查询成功");
    }

    @PostMapping(value="/count/type", produces={"application/json; charset=utf-8" })
    @ApiOperation("根据物资分类统计")
    public CommonResult countByType(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizCategory> queryFilter) {
        queryFilter.setPageBean(new PageBean(1,-1));
        List<CategoryNumVo> countByType = baseService.countByType(queryFilter);
        return CommonResult.success(countByType,"查询成功");
    }

    @PostMapping(value="/queryUnconfiguredTree", produces={"application/json; charset=utf-8" })
    @ApiOperation("查询未被准入资质配置的物资分类")
    public CommonResult queryUnconfiguredTree(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizCategory> queryFilter) {
        queryFilter.setPageBean(new PageBean(1,-1));
        List<BizCategory> tree = baseService.queryUnconfiguredTree(queryFilter);
        return CommonResult.success(tree,"查询成功");
    }

}
