package com.artfess.gyl.supplierOut.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 淘汰供应商供货情况表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-12-04
 */
@Data
@ApiModel(value="BizSupplierEnterpriseOutSupplyCondition对象", description="淘汰供应商供货情况表")
public class BizSupplierEnterpriseOutSupplyCondition extends BizDelModel<BizSupplierEnterpriseOutSupplyCondition> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "淘汰供应商记录ID")
    @TableField("SUPPLIER_ENTERPRISE_OUT_ID_")
    private String supplierEnterpriseOutId;

    @ApiModelProperty(value = "主要产品名称")
    @TableField("MAIN_PRODUCT_NAME_")
    private String mainProductName;

    @ApiModelProperty(value = "子产品名")
    @TableField("SUB_PRODUCT_NAME_")
    private String subProductName;

    @ApiModelProperty(value = "备份供应商名称")
    @TableField("BACKUP_SUPPLIER_NAME_")
    private String backupSupplierName;

    @ApiModelProperty(value = "未备份原因")
    @TableField("NOT_BACKUP_RESULT_")
    private String notBackupResult;

    @ApiModelProperty(value = "对策方案")
    @TableField("SCHEME_")
    private String scheme;
}
