package com.artfess.gyl.supplierEva.vo;

import com.artfess.gyl.supplierEva.model.*;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

@Data
public class EvaluationResultVo {

    @ApiModelProperty(value = "主键_ID")
    private String id;

    @ApiModelProperty(value = "绩效考核配置ID")
    private String valuationConfigurationId;

    @ApiModelProperty(value = "绩效考核配置NAME")
    private String valuationConfigurationName;

    @ApiModelProperty(value = "绩效考核配置CODE")
    private String valuationConfigurationCode;

    @ApiModelProperty(value = "企业ID")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    private String enterpriseName;

    @ApiModelProperty(value = "供应商分类id")
    private String supplierCategoryId;

    @ApiModelProperty(value = "供应商分类编码")
    private String supplierCategoryCode;

    @ApiModelProperty(value = "供应商分类名称")
    private String supplierCategoryName;

    @ApiModelProperty(value = "发起人ID")
    private String initiatorId;

    @ApiModelProperty(value = "发起人ACCOUNT")
    private String initiatorAccount;

    @ApiModelProperty(value = "发起人")
    private String initiatorName;

    @ApiModelProperty(value = "供应商ID")
    private String supplierId;

    @ApiModelProperty(value = "供应商")
    private String supplierName;

    @ApiModelProperty(value = "供应商编号")
    private String supplierCode;

    @ApiModelProperty(value = "考核类型（1月度考核，2季度考核，3年度考核，4自定义）")
    private String assessmentType;

    @ApiModelProperty(value = "考核开始日期")
    private LocalDate assessmentStartDate;

    @ApiModelProperty(value = "考核结束日期")
    private LocalDate assessmentEndDate;

    @ApiModelProperty(value = "考核年度")
    private Integer assessmentYear;

    @ApiModelProperty(value = "考核月度")
    private Integer assessmentMonth;

    @ApiModelProperty(value = "考核季度")
    private Integer assessmentQuater;

    @ApiModelProperty(value = "评审要求")
    private String desc;

    @ApiModelProperty(value = "总分值")
    private Integer totalScore;

    @ApiModelProperty(value = "考核得分")
    private BigDecimal operationScore;

    @ApiModelProperty(value = "等级(1：优秀，2：良好，3：合格，4：可改善，5：不合格)")
    private String level;

    @ApiModelProperty(value = "评价结论（1合格，2可改善，3不合格）")
    private String assessmentResult;

    @ApiModelProperty(value = "处置类型 0.无处置 1.预警 2.限期")
    private String processType;

    @ApiModelProperty(value = "状态(1：所有供应商已完成，2：已提交待评分，3评分中，4评分完毕待评价，5取消/关闭)")
    private String status;

    @ApiModelProperty(value = "是否已经评分")
    private String isOpt;

    @ApiModelProperty(value = "通知状态")
    private String notificationStatus;

    @ApiModelProperty(value = "通知单id")
    private String notificationId;

    @ApiModelProperty(value = "整改措施id")
    private String reportId;

    @ApiModelProperty(value = "整改状态")
    private String correctionStatus;

    @ApiModelProperty(value = "评分明细")
    private List<BizSupplierPerformanceEvaluationRating> details;

    @ApiModelProperty(value = "考核记录")
    private List<BizSupplierPerformanceEvaluationApprovalRecord> records;

    @ApiModelProperty(value = "考核通知")
    private BizSupplierPerformanceEvaluationNotification notification;

    @ApiModelProperty(value = "整改报告")
    private BizSupplierPerformanceEvaluationCorrectionReport report;

}
