package com.artfess.gyl.supplierEva.dto;

import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ResultEvaDTO {

    @ApiModelProperty(value = "主键_ID")
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    private String level;

    @ApiModelProperty(value = "合格供应商ID")
    private String supplierId;

    @ApiModelProperty(value = "供应商")
    private String supplierName;

    @ApiModelProperty(value = "供应商编号")
    private String supplierCode;

    @ApiModelProperty(value = "企业ID")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    private String enterpriseName;

    @ApiModelProperty(value = "通知分发类型(1.通过绩效考核分发 2.手动分发 默认为1)")
    private Integer distributeType;

    @ApiModelProperty(value = "评价结论（1合格，2可改善，3不合格）")
    private String assessmentResult;

    @ApiModelProperty(value = "考核评价ID")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "处理类型（1质量预警，2限期整改，3淘汰）")
    private String processType;

    @ApiModelProperty(value = "通知标题")
    private String notificationTitle;

    @ApiModelProperty(value = "通知内容")
    private String notificationContent;

    @ApiModelProperty(value = "通知日期")
    private LocalDateTime notifyDate;

    @ApiModelProperty(value = "要求回复截止日期")
    private LocalDateTime replyDeadline;

    @ApiModelProperty(value = "要求完成截止日期")
    private LocalDateTime finishDeadline;

    @ApiModelProperty(value = "通知状态(1已发送，2已确认，3已超期，4已关闭)")
    private String notificationStatus;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "企业联系人")
    private String enterpriseContact;

    @ApiModelProperty(value = "企业联系电话")
    private String enterpriseTel;

    @ApiModelProperty(value = "企业联系地址")
    private String enterpriseAddress;

    @ApiModelProperty(value = "考核类型")
    private String AssessmentType;

    @ApiModelProperty(value = "考核年份")
    private Integer assessmentYear;

    @ApiModelProperty(value = "考核月度")
    private Integer assessmentMonth;

    @ApiModelProperty(value = "考核季度")
    private Integer assessmentQuarter;

    @ApiModelProperty(value = "配置名称")
    private String valuationConfigurationName;

    @ApiModelProperty(value = "供应商基本信息")
    List<SupplierInfoDTO> supplierInfos;

}
