package com.artfess.gyl.supplierEva.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRatingUser;
import com.artfess.gyl.supplierEva.vo.SupplierScore;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationRatingUserManager;

import java.util.List;

/**
 * 供应商绩效考核评分用户 前端控制器
 *
 * @author huqi
 * @since 2025-11-22
 */
@RestController
@RequestMapping("/bizSupplierPerformanceEvaluationRatingUser/v1/")
@Api(tags = "供应商绩效考核-考核评价评分明细")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierPerformanceEvaluationRatingUserController extends BaseController<BizSupplierPerformanceEvaluationRatingUserManager, BizSupplierPerformanceEvaluationRatingUser> {

    @GetMapping("/getSupplierScore")
    @ApiOperation("查询供应商评分明细")
    public CommonResult<String> getUserRatings(@RequestParam("evaluationId") String evaluationId, @RequestParam("supplierId")String supplierId) {
        IUser user = ContextUtil.getCurrentUser();
        List<BizSupplierPerformanceEvaluationRatingUser> supplier = baseService.getSupplierByEvaId(evaluationId, supplierId, user.getAccount());
        return CommonResult.success(supplier,"查询成功");
    }

    @PostMapping("/batchUpdateForm")
    @ApiOperation("批量修改表单")
    public CommonResult<String> batchUpdateForm(@RequestBody List<BizSupplierPerformanceEvaluationRatingUser> ratingUsers) {
        boolean result = baseService.updateBatchById(ratingUsers);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return CommonResult.success(ratingUsers,"修改成功");
    }

}
