package com.artfess.gyl.supplierEva.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotificationTemplate;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationTemplateManager;

import java.util.Arrays;

/**
 * 供应商绩效考核通知信息表 前端控制器
 *
 * @author 管理员
 * @since 2025-12-12
 */
@RestController
@RequestMapping("/bizSupplierPerformanceEvaluationNotificationTemplate/v1/")
@Api(tags = "供应商-通知配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierPerformanceEvaluationNotificationTemplateController extends BaseController<BizSupplierPerformanceEvaluationNotificationTemplateManager, BizSupplierPerformanceEvaluationNotificationTemplate> {

    @PostMapping("/updateByStatus")
    @ApiOperation(value = "根据id修改状态")
    public CommonResult<String> updateStatus(@RequestParam("id")String id, @RequestParam("status")String status) {
        boolean res = baseService.updateStatusById(id, status);
        return new CommonResult(res?"修改成功":"修改失败");
    }

    @PostMapping(value = "/queryByOrg", produces = {"application/json; charset=utf-8"})
    @ApiOperation("根据组织匹配查询")
    public PageList<BizSupplierPerformanceEvaluationNotificationTemplate> queryByOrg(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierPerformanceEvaluationNotificationTemplate> queryFilter) {
        queryFilter.addFilter("CREATE_ORG_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return baseService.query(queryFilter);
    }

    @DeleteMapping(value = "/remove", produces = {"application/json; charset=utf-8"})
    @ApiOperation("根据id批量删除")
    public CommonResult<String> remove(@RequestParam("ids")String ids) {
        boolean res = baseService.remove(Arrays.asList(ids.split(",")));
        return new CommonResult(res?"删除成功":"删除失败");
    }


}
