package com.artfess.gyl.supplierEva.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationRatingUser;
import com.artfess.gyl.supplierEva.vo.*;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationManager;

import javax.validation.Valid;
import java.util.Arrays;
import java.util.List;

/**
 * 供应商绩效考核评价表 前端控制器
 *
 * @author huqi
 * @since 2025-11-12
 */
@RestController
@RequestMapping("/bizSupplierPerformanceEvaluation/v1/")
@Api(tags = "供应商绩效考核-考核评价配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierPerformanceEvaluationController extends BaseController<BizSupplierPerformanceEvaluationManager, BizSupplierPerformanceEvaluation> {

    @PostMapping("/groupSaveModel")
    @ApiOperation("保存供应商绩效考核配置")
    public CommonResult<String> groupSaveModel(@ApiParam(name = "model", value = "实体信息") @Valid @RequestBody EvaluationDTO dto) {
        Boolean result = baseService.batchCreateEvaluationFromTemplate(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"操作成功");
    }

    @GetMapping("/getModel/{id}")
    @ApiOperation("根据id查询详情")
    public CommonResult<String> getModel(@PathVariable("id") String id) {
        EvaluationResultVo model = baseService.getModelById(id);
        return CommonResult.success(model,"查询成功");
    }

    @GetMapping("/getUserModel/{id}")
    @ApiOperation("根据id查询详情")
    public CommonResult<String> getModelByUser(@PathVariable("id") String id) {
        EvaluationOptVo model = baseService.getModelByUser(id);
        return CommonResult.success(model,"查询成功");
    }

    @GetMapping("/getEvaluationUser/{id}")
    @ApiOperation("根据id查询用户评分情况")
    public CommonResult<String> getUserRatings(@PathVariable("id") String id) {
        List<SupplierScore> userRatings = baseService.getUserEvaluations(id);
        return CommonResult.success(userRatings,"查询成功");
    }

    @GetMapping("/getRatingUser")
    @ApiOperation("根据id查询用户评分情况")
    public CommonResult<String> getUserRatings(@RequestParam("evaluationId") String evaluationId,@RequestParam("detailsId") String detailsId) {
        List<SupplierScore> userRatings = baseService.getUserRatings(evaluationId,detailsId);
        return CommonResult.success(userRatings,"查询成功");
    }

    @PostMapping(value = "/queryByEva", produces = {"application/json; charset=utf-8"})
    @ApiOperation("企业-分页查询结果")
    public PageList<EvaluationVo> queryByEva(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addFilter("eva.INITIATOR_ACCOUNT_",user.getAccount(),QueryOP.EQUAL);
        return baseService.queryEvaluationList(queryFilter);
    }

    @PostMapping(value = "/queryByUser", produces = {"application/json; charset=utf-8"})
    @ApiOperation("专家-根据用户查询审评")
    public PageList<EvaluationVo> queryByUser(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("eva.IS_DELE_","0", QueryOP.EQUAL);
        IUser user = ContextUtil.getCurrentUser();
        return baseService.queryEvaluationListByUser(queryFilter,user.getAccount());
    }

    @PostMapping(value = "/queryByPersonalSum", produces = {"application/json; charset=utf-8"})
    @ApiOperation("专家-根据用户查询该项考核中对供应商的整体评分情况")
    public PageList<EvaluationVo> queryByPersonalSum(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        queryFilter.addFilter("r.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("rat.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("ru.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("ru.RATING_ACCOUNT_",user.getAccount(), QueryOP.EQUAL);
        return baseService.queryByPersonalSum(queryFilter);
    }

    @PostMapping(value = "/queryByHistory", produces = {"application/json; charset=utf-8"})
    @ApiOperation("企业-分页查询历史考核数据")
    public PageList<EvaluationVo> queryByHistory(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("eva.ENTERPRISE_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        queryFilter.addFilter("result.STATUS_","1", QueryOP.EQUAL);
        return baseService.queryEvaluationList(queryFilter);
    }

    @PostMapping(value = "/queryBySupplier", produces = {"application/json; charset=utf-8"})
    @ApiOperation("供应商-分页查询结果")
    public PageList<EvaluationVo> queryBySupplier(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierPerformanceEvaluation> queryFilter) {
        queryFilter.addFilter("result.SUPPLIER_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        return baseService.queryEvaluationList(queryFilter);
    }

    @PostMapping(value = "/userRating", produces = {"application/json; charset=utf-8"})
    @ApiOperation("用户评分")
    public CommonResult<String> userRating(@RequestBody List<BizSupplierPerformanceEvaluationRatingUser> ratingList) {
        boolean result = baseService.saveUserRating(ratingList);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(ratingList,"操作成功");
    }

    @PostMapping(value = "/subUserRating", produces = {"application/json; charset=utf-8"})
    @ApiOperation("提交用户评分")
    public CommonResult userRating(@RequestParam("evaluationId")String evaluationId) {
        boolean result = baseService.submitUserRating(evaluationId);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(true,"操作成功");
    }

    @PostMapping(value = "/userEva", produces = {"application/json; charset=utf-8"})
    @ApiOperation("用户评价")
    public CommonResult<String> userEva(@RequestBody ResultEvaDTO dto) {
        boolean result = baseService.submitUserEvaluation(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"操作成功");
    }

    @DeleteMapping(value = "/remove")
    @ApiOperation("批量删除")
    public CommonResult<String> remove(@RequestParam(required = true,value = "id")String id){
        List<String> resultIds = Arrays.asList(id.split(","));
        boolean result = baseService.remove(resultIds);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(resultIds,"操作成功");
    }

    @PostMapping(value = "/updateByIds")
    @ApiOperation("批量更新")
    public CommonResult<String> remove(@RequestParam(required = true,value = "ids")String ids,
                                       @RequestParam(required = true,value = "status")Integer status){
        List<String> idList = Arrays.asList(ids.split(","));
        boolean result = baseService.updateByIds(idList,status);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(result,"操作成功");
    }


}
