package com.artfess.gyl.supplierApply3.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 生产制造过程绩效表
 *
 * @author huqi
 * @since 2025-11-17
 */
@Data
@ApiModel(value="BizSupplierProductionProcessPerformance3对象", description="生产制造过程绩效表")
public class BizSupplierProductionProcessPerformance3 extends BizDelModel<BizSupplierProductionProcessPerformance3> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "生产工艺流程(可附页说明)")
    @TableField("SUPRODUCTION_PROCESS_")
    private String suproductionProcess;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;

    @ApiModelProperty(value = "生产工艺流程")
    @TableField(exist = false)
    private List<BizSupplierProductionProcessFlow3> flow;
}
