package com.artfess.gyl.supplierApply3.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 主要原材料及供应商表
 *
 * @author huqi
 * @since 2025-11-17
 */
@Data
@TableName("biz_supplier_main_raw_materials_suppliers3")
@ApiModel(value="BizSupplierMainRawMaterialsSuppliers3对象", description="主要原材料及供应商表")
public class BizSupplierMainRawMaterialsSuppliers3 extends BizDelModel<BizSupplierMainRawMaterialsSuppliers3> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "主要原料名称")
    @TableField("MAIN_RAW_MATERIAL_NAME_")
    private String mainRawMaterialName;

    @ApiModelProperty(value = "供应厂家")
    @TableField("SUPPLIER_")
    private String supplier;

    @ApiModelProperty(value = "上年度业绩表现")
    @TableField("PREVIOUS_YEAR_PERFORMANCE_")
    private String previousYearPerformance;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;

}
