package com.artfess.gyl.supplierApply3.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.supplierApply3.dto.SupplierRegisterDTO;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseRegisterInformation;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.supplierApply3.vo.SupplierRegisterVo;

/**
 * 合格供应商注册信息，在准入申请时默认查询出此数据并填充，如果没有此数据准入申请通过后默认添加一条此数据 服务类
 *
 * @author huqi
 * @since 2025-11-17
 */
public interface BizSupplierEnterpriseRegisterInformationManager extends BaseManager<BizSupplierEnterpriseRegisterInformation> {

    /**
     * 新增供应商基本信息
     * @param dto
     * @return
     */
    boolean saveOrUpdateModel(SupplierRegisterDTO dto);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    SupplierRegisterVo getById(String id);

    /**
     * 根据供应商id查询详情
     * @param id
     * @return
     */
    SupplierRegisterVo getBySupplierId(String id);

    /**
     * 通用查询
     * @param queryFilter
     * @return
     */
    PageList<BizSupplierEnterpriseRegisterInformation> queryByVersion(QueryFilter<BizSupplierEnterpriseRegisterInformation> queryFilter);

}
