package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商分类明细表	说明：供应商分类分级变更通过后，添加一条信息（版本号加1），每次查询都是查询版本号最大的数
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-18
 */
@Data
@ApiModel(value="BizSupplierEnterpriseCategory2对象", description="供应商分类明细表	说明：供应商分类分级变更通过后，添加一条信息（版本号加1），每次查询都是查询版本号最大的数")
public class BizSupplierEnterpriseCategory2 extends BizDelModel<BizSupplierEnterpriseCategory2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商准入ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "供应商分类ID（关联供应商分级表ID）")
    @TableField("SUPPLIER_CATEGORY_CONFIGURATION_ID_")
    private String supplierCategoryConfigurationId;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;
}
