package com.artfess.gyl.supplierApply2.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.base.model.BizEnterpriseBusinessLicense;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.supplierAccess.dto.BizSupplierAccessConfigurationDto;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessConfiguration;
import com.artfess.gyl.supplierAccess.vo.BizSupplierReviewConfigurationVo;
import com.artfess.gyl.supplierApply2.dto.EnterpriseAccess2Dto;
import com.artfess.gyl.supplierApply2.model.*;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.supplierApply2.vo.EnterpriseAccess2PageVo;
import com.artfess.gyl.supplierApply2.vo.EnterpriseAccess2Vo;
import com.artfess.gyl.supplierApply2.vo.FillingProgressVo;
import com.artfess.gyl.thirdParty.model.BizEnterprise;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 供应商准入申请表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-10
 */
public interface BizSupplierEnterpriseAccessManager extends BaseManager<BizSupplierEnterpriseAccess> {

    /**
     * 保存/修改-准入申请信息
     * @param dto
     * @return
     */
    Boolean saveOrUpdateEnterpriseAccess(EnterpriseAccess2Dto dto);

    /**
     * 保存/修改-准入申请其他信息
     * @param dto
     * @return
     */
    Boolean saveOrUpdateOtherInfo(EnterpriseAccess2Dto dto);

    /**
     * 查询-准入申请信息详情
     * @param id
     * @return
     */
    EnterpriseAccess2Vo getInfo(String id);

    /**
     * 分页查询-准入申请列表
     * @param queryFilter
     * @return
     */
    PageList<EnterpriseAccess2PageVo> queryPage(QueryFilter<BizSupplierEnterpriseAccess> queryFilter) throws InvocationTargetException, IllegalAccessException;

    /**
     * 查询-准入申请信息填报进度
     * @param id
     * @return
     */
    FillingProgressVo getFillingProgress(String id);

    /**
     * 查询供应商基本信息
     * @return
     */
    BizEnterpriseBusinessLicense getSupplierBasicInfo(String supplierId);

    /**
     * 查询-准入资质
     * @param enterpriseId
     * @param type
     * @return
     */
    List<BizSupplierQualificationDatabase> getQualificationByEnterpriseId(String enterpriseId, String type);

    /**
     * 审批-准入申请
     * @param accessApprovalRecord2
     * @return
     */
    Boolean audit(BizSupplierEnterpriseAccessApprovalRecord2 accessApprovalRecord2) throws InvocationTargetException, IllegalAccessException;

    /**
     * 提交-准入申请
     * @param id
     * @return
     */
    Boolean submit(String id);

    /**
     * 查询-审批日志
     * @param id
     * @return
     */
    List<BizSupplierEnterpriseAccessApprovalRecord2> queryApprovalLogs(String id);

    /**
     * 查询-准入评审配置
     * @return
     */
    List<BizSupplierReviewConfigurationVo> getReviewConfiguration(String id);

    /**
     * 查询评审成员
     * @param id
     * @return
     */
    List<BizSupplierReviewReportPanel2> getReportPanel(String id);

    /**
     * 查询-试用评审报告评审成员成员
     * @param id
     * @return
     */
    List<BizSupplierReviewTrialReportPanel2> getTrialReportPanel(String id);

    /**
     * 查询-计算现场评审评分
     * @param id
     * @return
     */
    String getEnterpriseScore(String id);

    /**
     * 准入申请查询资质
     * @param categoryId
     * @param type
     * @return
     */
    List<BizSupplierQualificationDatabase> getQualification(String categoryId, String type);

    /**
     * 查询-关联企业
     * @param phones
     * @return
     */
    List<BizEnterprise> getAffiliatedEnterprise(String[] phones,String supplierId);

    /**
     * 抓取企业人员信息
     * @param supplierId
     * @return
     */
    List<BizSupplierAccessEnterprisePersonnel2> getEnterprisePersonnel(String supplierId) throws InvocationTargetException, IllegalAccessException;

    /**
     * 企业根据物资类型查询准入配置
     * @param categoryId
     * @return
     */
    BizSupplierAccessConfiguration getAccessConfiguration(String categoryId);

    /**
     * 查询企业信息
     * @return
     */
    BizEnterprise getOwnerEnterprise();

    FillingProgressVo getMenu(String categoryId,String id);

    public String selectTotalAmount(String supplierId);
}
