package com.artfess.gyl.supplierApply.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 供应商人员信息表2
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-12-02
 */
@ApiModel(value="BizSupplierAccessEnterprisePersonnel对象", description="供应商人员信息表2")
public class BizSupplierAccessEnterprisePersonnel extends BaseModel<BizSupplierAccessEnterprisePersonnel> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商准入ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "企业id")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "用户姓名")
    @TableField("FULLNAME_")
    private String fullname;

    @ApiModelProperty(value = "用户编号")
    @TableField("USER_NUMBER_")
    private String userNumber;

    @ApiModelProperty(value = "性别（男，女，未知）")
    @TableField("SEX_")
    private String sex;

    @ApiModelProperty(value = "出生日期")
    @TableField("BIRTHDAY_")
    private LocalDate birthday;

    @ApiModelProperty(value = "国家")
    @TableField("COUNTRY_")
    private String country;

    @ApiModelProperty(value = "民族")
    @TableField("NATION_")
    private String nation;

    @ApiModelProperty(value = "政治面貌（使用字典：01中共党员，02中共预备党员，03共青团员，04民革党员，05民盟盟员，06民建会员，07民进会员，08农工党党员，09致公党党员，10九三学社社员，11台盟盟员，12无党派人士，13群众）")
    @TableField("POLITICAL_OUTLOOK_")
    private String politicalOutlook;

    @ApiModelProperty(value = "身份证号")
    @TableField("ID_CARD_")
    private String idCard;

    @ApiModelProperty(value = "工作地址")
    @TableField("ADDRESS_")
    private String address;

    @ApiModelProperty(value = "参加工作时间")
    @TableField("ENTRY_DATE_")
    private LocalDate entryDate;

    @ApiModelProperty(value = "职务")
    @TableField("DUTIES_")
    private String duties;

    @ApiModelProperty(value = "执业资质")
    @TableField("PROFESSIONAL_QUALIFICATIONS_")
    private String professionalQualifications;

    @ApiModelProperty(value = "学历")
    @TableField("EDUCATION_")
    private String education;

    @ApiModelProperty(value = "学位")
    @TableField("ACADEMIC_DEGREE_")
    private String academicDegree;

    @ApiModelProperty(value = "健康状况")
    @TableField("HEALTH_CONDITION_")
    private String healthCondition;

    @ApiModelProperty(value = "办公电话")
    @TableField("PHONE_")
    private String phone;

    @ApiModelProperty(value = "手机号码")
    @TableField("MOBILE_")
    private String mobile;

    @ApiModelProperty(value = "QQ")
    @TableField("QQ_")
    private String qq;

    @ApiModelProperty(value = "MSN")
    @TableField("MSN_")
    private String msn;

    @ApiModelProperty(value = "邮箱")
    @TableField("EMAIL_")
    private String email;

    @ApiModelProperty(value = "所属行政区划_ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_")
    private String sysAreasId;

    @ApiModelProperty(value = "所属行政区划_NAME（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_")
    private String sysAreasName;

    @ApiModelProperty(value = "所属行政区划_全路径ID（关联行政区划表）")
    @TableField("SYS_AREAS_ID_PATH_")
    private String sysAreasIdPath;

    @ApiModelProperty(value = "属行政区划_全路径名称（关联行政区划表）")
    @TableField("SYS_AREAS_NAME_PATH_")
    private String sysAreasNamePath;

    @ApiModelProperty(value = "门户账号")
    @TableField("ACCOUNT_")
    private String account;

    @ApiModelProperty(value = "简历")
    @TableField("BIOGRAPHICAL_NOTES_")
    private String biographicalNotes;

    @ApiModelProperty(value = "照片附件URL")
    @TableField("PHOTO_")
    private String photo;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "状态（0：禁用，1：启用）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人部门ID")
    @TableField("CREATE_DEPT_ID_")
    private String createDeptId;

    @ApiModelProperty(value = "创建人部门名称")
    @TableField("CREATE_DEPT_NAME_")
    private String createDeptName;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人部门名称")
    @TableField("UPDATE_DEPT_NAME_")
    private String updateDeptName;

    @ApiModelProperty(value = "更新人部门ID")
    @TableField("UPDATE_DEPT_ID_")
    private String updateDeptId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSupplierEnterpriseId() {
        return supplierEnterpriseId;
    }

    public void setSupplierEnterpriseId(String supplierEnterpriseId) {
        this.supplierEnterpriseId = supplierEnterpriseId;
    }

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public String getEnterpriseCode() {
        return enterpriseCode;
    }

    public void setEnterpriseCode(String enterpriseCode) {
        this.enterpriseCode = enterpriseCode;
    }

    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public LocalDate getBirthday() {
        return birthday;
    }

    public void setBirthday(LocalDate birthday) {
        this.birthday = birthday;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }

    public String getPoliticalOutlook() {
        return politicalOutlook;
    }

    public void setPoliticalOutlook(String politicalOutlook) {
        this.politicalOutlook = politicalOutlook;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public LocalDate getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(LocalDate entryDate) {
        this.entryDate = entryDate;
    }

    public String getDuties() {
        return duties;
    }

    public void setDuties(String duties) {
        this.duties = duties;
    }

    public String getProfessionalQualifications() {
        return professionalQualifications;
    }

    public void setProfessionalQualifications(String professionalQualifications) {
        this.professionalQualifications = professionalQualifications;
    }

    public String getEducation() {
        return education;
    }

    public void setEducation(String education) {
        this.education = education;
    }

    public String getAcademicDegree() {
        return academicDegree;
    }

    public void setAcademicDegree(String academicDegree) {
        this.academicDegree = academicDegree;
    }

    public String getHealthCondition() {
        return healthCondition;
    }

    public void setHealthCondition(String healthCondition) {
        this.healthCondition = healthCondition;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public String getMsn() {
        return msn;
    }

    public void setMsn(String msn) {
        this.msn = msn;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSysAreasId() {
        return sysAreasId;
    }

    public void setSysAreasId(String sysAreasId) {
        this.sysAreasId = sysAreasId;
    }

    public String getSysAreasName() {
        return sysAreasName;
    }

    public void setSysAreasName(String sysAreasName) {
        this.sysAreasName = sysAreasName;
    }

    public String getSysAreasIdPath() {
        return sysAreasIdPath;
    }

    public void setSysAreasIdPath(String sysAreasIdPath) {
        this.sysAreasIdPath = sysAreasIdPath;
    }

    public String getSysAreasNamePath() {
        return sysAreasNamePath;
    }

    public void setSysAreasNamePath(String sysAreasNamePath) {
        this.sysAreasNamePath = sysAreasNamePath;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getBiographicalNotes() {
        return biographicalNotes;
    }

    public void setBiographicalNotes(String biographicalNotes) {
        this.biographicalNotes = biographicalNotes;
    }

    public String getPhoto() {
        return photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }

    public String getCreateDeptId() {
        return createDeptId;
    }

    public void setCreateDeptId(String createDeptId) {
        this.createDeptId = createDeptId;
    }

    public String getCreateDeptName() {
        return createDeptName;
    }

    public void setCreateDeptName(String createDeptName) {
        this.createDeptName = createDeptName;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    public String getUpdateDeptName() {
        return updateDeptName;
    }

    public void setUpdateDeptName(String updateDeptName) {
        this.updateDeptName = updateDeptName;
    }

    public String getUpdateDeptId() {
        return updateDeptId;
    }

    public void setUpdateDeptId(String updateDeptId) {
        this.updateDeptId = updateDeptId;
    }

    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }

    public String getUpdateOrgName() {
        return updateOrgName;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSupplierAccessEnterprisePersonnel{" +
            "id=" + id +
            ", supplierEnterpriseId=" + supplierEnterpriseId +
            ", enterpriseId=" + enterpriseId +
            ", enterpriseName=" + enterpriseName +
            ", enterpriseCode=" + enterpriseCode +
            ", fullname=" + fullname +
            ", userNumber=" + userNumber +
            ", sex=" + sex +
            ", birthday=" + birthday +
            ", country=" + country +
            ", nation=" + nation +
            ", politicalOutlook=" + politicalOutlook +
            ", idCard=" + idCard +
            ", address=" + address +
            ", entryDate=" + entryDate +
            ", duties=" + duties +
            ", professionalQualifications=" + professionalQualifications +
            ", education=" + education +
            ", academicDegree=" + academicDegree +
            ", healthCondition=" + healthCondition +
            ", phone=" + phone +
            ", mobile=" + mobile +
            ", qq=" + qq +
            ", msn=" + msn +
            ", email=" + email +
            ", sysAreasId=" + sysAreasId +
            ", sysAreasName=" + sysAreasName +
            ", sysAreasIdPath=" + sysAreasIdPath +
            ", sysAreasNamePath=" + sysAreasNamePath +
            ", account=" + account +
            ", biographicalNotes=" + biographicalNotes +
            ", photo=" + photo +
            ", remarks=" + remarks +
            ", status=" + status +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createName=" + createName +
            ", createOrgId=" + createOrgId +
            ", createOrgName=" + createOrgName +
            ", createDeptId=" + createDeptId +
            ", createDeptName=" + createDeptName +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateName=" + updateName +
            ", updateDeptName=" + updateDeptName +
            ", updateDeptId=" + updateDeptId +
            ", updateOrgId=" + updateOrgId +
            ", updateOrgName=" + updateOrgName +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
            ", version=" + version +
            ", tenantId=" + tenantId +
        "}";
    }
}
