package com.artfess.gyl.supplierAccess.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入配置&基础物料分类关联表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-07
 */
@Data
@ApiModel(value="BizSupplierAccessConfigurationMaterialCategory对象", description="供应商准入配置&基础物料分类关联表")
public class BizSupplierAccessConfigurationMaterialCategory extends AutoFillFullModel<BizSupplierAccessConfigurationMaterialCategory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入配置ID")
    @TableField("SUPPLIER_ACCESS_ID_")
    private String supplierAccessId;

    @ApiModelProperty(value = "准入配置CODE")
    @TableField("SUPPLIER_ACCESS_CODE_")
    private String supplierAccessCode;

    @ApiModelProperty(value = "基础物料分类ID（关联基础物料分类表ID）")
    @TableField("CATEGORY_ID_")
    private String categoryId;

    @ApiModelProperty(value = "基础物料分类编号（关联基础物料分类表CODE）")
    @TableField("CATEGORY_PLATCODE_")
    private String categoryPlatcode;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
