package com.artfess.gyl.supplierAccess.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.supplierAccess.dto.BizSupplierAccessConfigurationDto;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessConfiguration;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.supplierAccess.vo.BizSupplierAccessConfigurationVo;

import java.util.List;

/**
 * 供应商准入配置表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-07
 */
public interface BizSupplierAccessConfigurationManager extends BaseManager<BizSupplierAccessConfiguration> {

    /**
     * 保存供应商准入配置
     * @param supplierAccessConfigurationDto
     * @return
     */
    Boolean saveModel(BizSupplierAccessConfigurationDto supplierAccessConfigurationDto);

    /**
     * 供应商准入配置详情
     * @param id
     * @return
     */
    BizSupplierAccessConfigurationVo getInfo(String id);

    /**
     * 修改供应商准入配置
     * @param supplierAccessConfigurationDto
     * @return
     */
    Boolean updateModel(BizSupplierAccessConfigurationDto supplierAccessConfigurationDto);

    /**
     * 根据id集合批量删除
     * @param ids
     * @return
     */
    Boolean batchDelete(String[] ids);

    /**
     * 分页查询
     * @param queryFilter
     * @return
     */
    PageList<BizSupplierAccessConfigurationVo> queryPage(QueryFilter<BizSupplierAccessConfiguration> queryFilter);

    /**
     * 查询企业准入资质配置
     * @param queryFilter
     * @return
     */
    List<BizSupplierAccessConfiguration> getListByEnterprise(QueryFilter<BizSupplierAccessConfiguration> queryFilter);

    /**
     * 修改启用状态
     * @param id
     * @param status
     * @return
     */
    Boolean updateStatus(String id, String status);
}
