package com.artfess.gyl.supplierAccess.dto;

import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfiguration;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfigurationDetails;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfigurationDetailsPanel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

@Data
public class BizSupplierReviewConfigurationDetailsDto {
    @ApiModelProperty(value = "主键_ID")
    private String id;

    @ApiModelProperty(value = "评审配置ID")
    private String reviewConfigurationId;

    @ApiModelProperty(value = "指标类别名称")
    private String classificationName;

    @ApiModelProperty(value = "指标类别编码")
    private String classificationCode;

    @ApiModelProperty(value = "评审指标编码")
    private String code;

    @ApiModelProperty(value = "评审内容")
    private String name;

    @ApiModelProperty(value = "评审要求")
    private String desc;

    @ApiModelProperty(value = "分值")
    private Integer score;

    @ApiModelProperty(value = "权重（百分比）")
    private Float weight;

    @ApiModelProperty(value = "默认评分人ID")
    private String ratingId;

    @ApiModelProperty(value = "默认评分人ACCOUNT")
    private String ratingAccount;

    @ApiModelProperty(value = "默认评分人")
    private String ratingName;

    @ApiModelProperty(value = "状态(1：启用，0：禁用)")
    private String status;

    @ApiModelProperty(value = "排序号")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    private String isDele;

    @ApiModelProperty(value = "评审成员")
    List<BizSupplierReviewConfigurationDetailsPanel> panelList;

    public static BizSupplierReviewConfigurationDetails parse(BizSupplierReviewConfigurationDetailsDto dto){
        BizSupplierReviewConfigurationDetails model = new BizSupplierReviewConfigurationDetails();
        try {
            BeanUtils.copyNotNullProperties(model,dto);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return model;
    }
}
