package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商分类供货范围明细表
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Data
@TableName("BIZ_SUPPLIER_CATEGORY_SUPPLY_SCOPE")
@ApiModel(value="BizSupplierCategorySupplyScope对象", description="供应商分类供货范围明细表")
public class BizSupplierCategorySupplyScope extends BizDelModel<BizSupplierCategorySupplyScope> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商分类ID")
    @TableField("SUPPLIER_CATEGORY_CONFIGURATION_ID_")
    private String supplierCategoryConfigurationId;

    @ApiModelProperty(value = "物料分类ID")
    @TableField("SUPPLIER_MATERIAL_CATEGORY_ID_")
    private String supplierMaterialCategoryId;

    @ApiModelProperty(value = "物料分类编码")
    @TableField("SUPPLIER_MATERIAL_CATEGORY_CODE_")
    private String supplierMaterialCategoryCode;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;
}
