package com.artfess.gyl.base.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购合同表
 *
 * @author huqi
 * @since 2025-12-04
 */
@Data
@TableName("biz_contract")
@ApiModel(value="BizContract对象", description="采购合同表")
public class BizContract extends BaseModel<BizContract> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "合同编号")
    @TableField("CONTR_CODE_")
    private String contrCode;

    @ApiModelProperty(value = "合同名称")
    @TableField("CONTR_NAME_")
    private String contrName;

    @ApiModelProperty(value = "类型名称")
    @TableField("CONTR_METHOD_")
    private String contrMethod;

    @ApiModelProperty(value = "第三方合同id")
    @TableField("THREE_CONTR_ID_")
    private String threeContrId;

    @ApiModelProperty(value = "采购公司编号")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "供应商编号")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "供应商税号")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "合同签订日期")
    @TableField("CONTR_QDRQ_")
    private String contrQdrq;

    @ApiModelProperty(value = "合同创建时间")
    @TableField("CONTR_CREATE_TIME_")
    private String contrCreateTime;

    @ApiModelProperty(value = "最后修改时间")
    @TableField("CONTR_LAST_TIME_")
    private LocalDateTime contrLastTime;

    @ApiModelProperty(value = "签订人")
    @TableField("CONTR_QDR_")
    private String contrQdr;

    @ApiModelProperty(value = "审批人")
    @TableField("CONTR_CHECKER_")
    private String contrChecker;

    @ApiModelProperty(value = "对方签订人")
    @TableField("CONTR_DFQDR_")
    private String contrDfqdr;

    @ApiModelProperty(value = "合同有效期开始时间")
    @TableField("CONTR_START_DATE_")
    private String contrStartDate;

    @ApiModelProperty(value = "合同有效期结束时间")
    @TableField("CONTR_END_DATE_")
    private String contrEndDate;

    @ApiModelProperty(value = "读取状态（0：未读取，1：已读取）")
    @TableField("READ_STATUS_")
    private Integer readStatus;
}
