package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.model.*;
import com.artfess.gyl.base.dao.BizSupplierQualificationDatabaseDao;
import com.artfess.gyl.base.manager.BizSupplierQualificationDatabaseManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商资质库表，（供应商修改资质库文件提交后，是新添加一条数据，版本加1），新建的资质版本默认为1，这样就可以和供应商的 服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-08
 */
@Service
public class BizSupplierQualificationDatabaseManagerImpl extends BaseManagerImpl<BizSupplierQualificationDatabaseDao, BizSupplierQualificationDatabase> implements BizSupplierQualificationDatabaseManager {
    @Resource
    private FileManager fileManager;
    @Resource
    private SysIdentityManager sysIdentityManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizSupplierQualificationDatabase entity){
        List<DefaultFile> files = entity.getFiles();
        Asserts.notNull(files,"需上传的资质附件不能为空");
        if (entity.getTimeLimit() == null){
           entity.setTimeLimit(1);
       }
        String number = sysIdentityManager.nextId("qyzzlsh");
        entity.setQualificationCategoryNumber(number);
        boolean save = super.save(entity);
        if (!save) {
            return false;
        }
        //更新附件
        List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
        //更新附件
        fileManager.updateFileBizIdByIds(fileIds,entity.getId());
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateById(BizSupplierQualificationDatabase entity){
        String oldId = entity.getId();
        Asserts.notNull(entity.getQualificationCategoryNumber(),"需迭代的版本流水号不能为空");
        List<DefaultFile> files = entity.getFiles();
        Asserts.notNull(files,"需上传的资质附件不能为空");
        //查询最大版本号
        Long maxVersion= baseMapper.selectMaxVersionByCategoryNumber(entity.getQualificationCategoryNumber());
        entity.setVersion(maxVersion+1);
        if (entity.getTimeLimit() == 1){
            entity.setValidUntil(null);
        }else {
            if (entity.getValidUntil() == null){
                throw new ApplicationException("请输入有效截止期");
            }
        }
        entity.setId(null);
        boolean update = super.save(entity);
        if (!update) {
            return false;
        }
        // 获取新附件ID列表
        List<String> newFileIds = files.stream()
                .map(DefaultFile::getId)
                .collect(Collectors.toList());
        // 查询现有附件
        List<DefaultFile> existingFiles = fileManager.queryFileByBizId(oldId);
        // 分离需要处理的附件
        Map<Boolean, List<DefaultFile>> partitionedFiles = existingFiles.stream()
                .collect(Collectors.partitioningBy(file -> newFileIds.contains(file.getId())));
       // 取消关联不再需要的附件
        List<DefaultFile> filesToRemove = partitionedFiles.get(false);
        if (CollectionUtils.isNotEmpty(filesToRemove)) {
            filesToRemove.forEach(file -> file.setBizId(null));
            fileManager.updateBatchById(filesToRemove);
        }
        // 关联新附件（自动处理重复）
        if (CollectionUtils.isNotEmpty(newFileIds)) {
            fileManager.updateFileBizIdByIds(newFileIds, entity.getId());
        }
        return true;
    }

    @Override
    @Transactional(readOnly = true)
    public BizSupplierQualificationDatabase getById(Serializable id) {
        BizSupplierQualificationDatabase entity = super.getById(id);
        //查询附件
        if (entity !=null){
            List<DefaultFile> defaultFiles = fileManager.queryFileByBizId(entity.getId());
            if (CollectionUtils.isNotEmpty(defaultFiles)){
                entity.setFiles(defaultFiles);
            }
        }
        return entity;
    }

    @Override
    @Transactional(readOnly = true)
    public PageList<BizSupplierQualificationDatabase> queryByPage(QueryFilter<BizSupplierQualificationDatabase> queryFilter) {
        IPage<BizSupplierQualificationDatabase> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    @Transactional(readOnly = true)
    public PageList<BizSupplierQualificationDatabase> queryByQuaSupplier(QueryFilter<BizSupplierQualificationDatabase> queryFilter) {
        queryFilter.addFilter("sn.IS_DELE_","0", QueryOP.EQUAL);
        IPage<BizSupplierQualificationDatabase> iPage = baseMapper.queryByQuaSupplier(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    @Transactional(readOnly = true)
    public List<BizSupplierQualificationDatabase> listByCategoryCode(List<String> categoryCode,String enterpriseId) {
        return baseMapper.listByCategoryCode(categoryCode,enterpriseId);
    }

//    @Override
//    public boolean saveModel(BizSupplierQualificationDatabase entity) {
//        return false;
//    }
//
//    @Override
//    public boolean updateModel(BizSupplierQualificationDatabase entity) {
//        return false;
//    }
}
