package com.artfess.gyl.base.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.base.model.BizSupplierGradingConfiguration;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.base.manager.BaseManager;
import com.artfess.gyl.supplierEva.dto.EvaluationDTO;

import java.util.List;

/**
 * 供应商资质库表，（供应商修改资质库文件提交后，是新添加一条数据，版本加1），新建的资质版本默认为1，这样就可以和供应商的 服务类
 *
 * @author 系统管理员
 * @since 2025-11-08
 */
public interface BizSupplierQualificationDatabaseManager extends BaseManager<BizSupplierQualificationDatabase> {

    /**
     * 通用查询
     * @param queryFilter
     * @return
     */
    PageList<BizSupplierQualificationDatabase> queryByPage(QueryFilter<BizSupplierQualificationDatabase> queryFilter);

    /**
     * 通用查询
     * @param queryFilter
     * @return
     */
    PageList<BizSupplierQualificationDatabase> queryByQuaSupplier(QueryFilter<BizSupplierQualificationDatabase> queryFilter);

    /**
     * 准入申请查询资质
     * @param categoryCode
     * @return
     */
    List<BizSupplierQualificationDatabase> listByCategoryCode(List<String> categoryCode,String enterpriseId);
}
