package com.artfess.gyl.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizEnterprisePersonnel;
import com.artfess.gyl.base.manager.BizEnterprisePersonnelManager;

/**
 * 企业人员管理 前端控制器
 *
 * @author huqi
 * @since 2025-11-21
 */
@RestController
@RequestMapping("/bizEnterprisePersonnel/v1/")
@Api(tags = "企业人员管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizEnterprisePersonnelController extends BaseController<BizEnterprisePersonnelManager, BizEnterprisePersonnel> {

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizEnterprisePersonnel> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizEnterprisePersonnel> queryFilter) {
        queryFilter.addFilter("ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return baseService.query(queryFilter);
    }
}
