/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.easyExcel.util.limiter;

import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import java.util.stream.LongStream;

public class SlidingWindow<T> {
    private int windowSize;
    private long dataPacketTotal;
    private LongFunction<T> producerDataPacketFunction;
    private Consumer<T> consumerDataPacketFunction;

    public static <T> SlidingWindow<T> create(Class<T> dataClass, int windowSize, long dataPacketTotal) {
        SlidingWindow<T> slidingWindow = new SlidingWindow<T>();
        slidingWindow.windowSize = windowSize;
        slidingWindow.dataPacketTotal = dataPacketTotal;
        return slidingWindow;
    }

    public SlidingWindow<T> sendWindow(LongFunction<T> producerDataPacketFunction) {
        this.producerDataPacketFunction = producerDataPacketFunction;
        return this;
    }

    public SlidingWindow<T> receiveWindow(Consumer<T> consumerDataPacketFunction) {
        this.consumerDataPacketFunction = consumerDataPacketFunction;
        return this;
    }

    public void start() throws InterruptedException, ExecutionException {
        if (this.dataPacketTotal <= 0L) {
            return;
        }
        if (this.dataPacketTotal == 1L) {
            this.consumerDataPacketFunction.accept(this.producerDataPacketFunction.apply(1L));
            return;
        }
        long finalWindowSize = Math.min((long)this.windowSize, this.dataPacketTotal);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, (int)finalWindowSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), new ThreadPoolExecutor.CallerRunsPolicy());
        LinkedList<CompletableFuture<Object>> windowList = new LinkedList<CompletableFuture<Object>>();
        LongStream.rangeClosed(1L, finalWindowSize).forEach(index -> windowList.add(CompletableFuture.supplyAsync(() -> this.producerDataPacketFunction.apply(index), threadPoolExecutor)));
        long current = 1L;
        do {
            this.consumerDataPacketFunction.accept(((CompletableFuture)windowList.remove(0)).get());
            if (this.dataPacketTotal - finalWindowSize < current) continue;
            long index2 = finalWindowSize + current;
            windowList.add(CompletableFuture.supplyAsync(() -> this.producerDataPacketFunction.apply(index2), threadPoolExecutor));
        } while (++current <= this.dataPacketTotal);
    }
}

