/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.ProgressStatus;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HuaweiyunOssUtil {
    private static final Logger log = LoggerFactory.getLogger(HuaweiyunOssUtil.class);
    private static String ak;
    private static String sk;
    private static String bucketName;
    private static String endpoint;
    private static ObsClient obsClient;

    public static String getAk() {
        return ak;
    }

    public static void setAk(String ak) {
        HuaweiyunOssUtil.ak = ak;
    }

    public static String getSk() {
        return sk;
    }

    public static void setSk(String sk) {
        HuaweiyunOssUtil.sk = sk;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static void setBucketName(String bucketName) {
        HuaweiyunOssUtil.bucketName = bucketName;
    }

    public static String getEndpoint() {
        return endpoint;
    }

    public static void setEndpoint(String endpoint) {
        HuaweiyunOssUtil.endpoint = endpoint;
    }

    public static boolean uploadFile(String path) {
        try {
            HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
            File file = new File(path);
            FileInputStream fis = new FileInputStream(file);
            PutObjectResult response = obsClient.putObject(bucketName, file.getName(), (InputStream)fis);
            int statusCode = response.getStatusCode();
            obsClient.close();
            if (200 == statusCode) {
                return true;
            }
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return false;
    }

    public static boolean uploadFile(String fileName, InputStream is) {
        try {
            HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
            PutObjectResult response = obsClient.putObject(bucketName, fileName, is);
            int statusCode = response.getStatusCode();
            is.close();
            obsClient.close();
        }
        catch (ObsException e) {
            System.out.println("HTTP Code: " + e.getResponseCode());
            System.out.println("Error Code:" + e.getErrorCode());
            System.out.println("Request ID:" + e.getErrorRequestId());
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static byte[] Download(String fileName, OutputStream out) throws IOException {
        int len;
        HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
        ObsObject obsObject = obsClient.getObject(bucketName, fileName);
        InputStream input = obsObject.getObjectContent();
        byte[] b = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = input.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.close();
        input.close();
        obsClient.close();
        return bos.toByteArray();
    }

    public static void DownloadChange(String fileName) throws IOException {
        int len;
        HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
        GetObjectRequest request = new GetObjectRequest(bucketName, fileName);
        request.setProgressListener(new ProgressListener(){

            public void progressChanged(ProgressStatus status) {
                System.out.println("AverageSpeed:" + status.getAverageSpeed());
                System.out.println("TransferPercentage:" + status.getTransferPercentage());
            }
        });
        request.setProgressInterval(0x100000L);
        ObsObject obsObject = obsClient.getObject(request);
        System.out.println(obsObject.toString());
        InputStream input = obsObject.getObjectContent();
        byte[] b = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = input.read(b)) != -1) {
            bos.write(b, 0, len);
        }
        System.out.println(new String(bos.toByteArray()));
        bos.close();
        input.close();
    }

    public static String getDownloadUrl(String fileName) {
        HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
        long expireSeconds = 3600L;
        TemporarySignatureRequest request = new TemporarySignatureRequest(HttpMethodEnum.GET, expireSeconds);
        request.setBucketName(bucketName);
        request.setObjectKey(fileName);
        TemporarySignatureResponse response = obsClient.createTemporarySignature(request);
        return response.getSignedUrl();
    }

    public static boolean chekckFile(String fileName) {
        HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
        ObjectMetadata metadata = obsClient.getObjectMetadata(bucketName, fileName);
        return metadata != null;
    }

    public static boolean deleteFile(String fileName) {
        try {
            HuaweiyunOssUtil.initObsClient(ak, sk, endpoint);
            obsClient.deleteObject(bucketName, fileName);
            obsClient.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static ObsClient initObsClient(String ak, String sk, String endpoint) {
        obsClient = new ObsClient(ak, sk, endpoint);
        return obsClient;
    }

    static {
        obsClient = null;
    }
}

