package com.artfess.file.service.impl;


import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.file.service.FilePreview;
import com.artfess.file.util.FileUtils;
import com.artfess.file.util.UploadM3u8;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author : kl
 * @authorboke : kailing.pub
 * @create : 2018-03-25 上午11:58
 * @description:
 **/
@SuppressWarnings(value = {"unchecked", "rawtypes"})
@Slf4j
@Service
public class MediaFilePreviewImpl implements FilePreview {

    @Resource
    private FileManager fileManager;
    @Override
    public String filePreviewHandle(DefaultFile fileMode, Map map) {
        String mediaUrl = fileMode.getProp4();
        if(StringUtil.isEmpty(mediaUrl)){
            // 不存在，可能之前转换失败了，这里尝试再次转换
            UploadM3u8 uploadM3u8 = new UploadM3u8();
            final String url = uploadM3u8.uploadVideoToM3U8(fileMode);
            fileMode.setProp4(url);
            fileManager.updateById(fileMode);
            log.info("视屏转换成功!");
            mediaUrl = url;
        }
        map.put("mediaUrl", mediaUrl);
        return "media";
    }

}
