package com.artfess.easyExcel.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.google.common.collect.Maps;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * 删除状态转换
 */
public class DelStatusConverter implements Converter<String> {

    private static Map<String,String> delStatusMap = Maps.newHashMap();

    //baseService是项目中封装的一个组件类，间接调用dao中的方法，并对返回结果进行了处理封装
//    private BaseService baseService;

    //懒汉模式构造器，将状态码映射关系注入进map中，不必每次都连接数据库进行查询
    public DelStatusConverter() {
        delStatusMap.put("0", "未删除");
        delStatusMap.put("1", "已删除");
//        baseService = SpringApplicationUtils.getBean(BaseService.class);
//        if (CollectionUtil.isEmpty(statusMap)){
//            statusMap = baseService.getItemMap(DictTypeConstants.D_ENABLE_STATUS);
//        }

    }

    @Override
    public Class supportJavaTypeKey() {
        return Integer.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(ReadConverterContext<?> context) {
        String delStatusName = context.getReadCellData().getStringValue();
        for (String delStatus : delStatusMap.keySet()) {
            if(delStatusName.equals(delStatusMap.get(delStatus)) ){
                return delStatus;
            }
        }
        return null;
    }

    @Override
    public WriteCellData<?> convertToExcelData(String delStatus, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String enableStatusName = delStatusMap.get(delStatus);
        enableStatusName = StringUtils.isEmpty(enableStatusName) ? "" : enableStatusName;
        return new WriteCellData<>(enableStatusName);
    }
}
