package com.artfess.easyExcel.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import java.nio.charset.StandardCharsets;

public class ByteArrayConverter implements Converter<byte[]> {
    public ByteArrayConverter() {
    }

    @Override
    public Class<byte[]> supportJavaTypeKey() {
        return byte[].class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public byte[] convertToJavaData(ReadConverterContext<?> context) {
        String stringValue = context.getReadCellData().getStringValue();
        return stringValue.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<byte[]> context) {
        return new WriteCellData((byte[])context.getValue());
    }
}
