/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.def;

import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.def.BpmDefXmlHandler;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.persistence.manager.BpmDefDataManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.model.BpmDefData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;

public abstract class AbstractBpmDefXmlHandler<T>
implements BpmDefXmlHandler<T> {
    @Resource
    protected BpmDefinitionManager bpmDefinitionManager;
    @Resource
    protected BpmDefDataManager bpmDefDataManager;
    @Resource
    protected BpmDefinitionAccessor bpmDefinitionAccessor;

    protected void updateXml(String defId, String bpmnXml) {
        BpmDefData bpmData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)defId));
        bpmData.setBpmnXml(bpmnXml);
        this.bpmDefinitionManager.updBpmData(defId, bpmData);
    }

    protected abstract String getXml(String var1, String var2, T var3) throws Exception;

    @Override
    public void saveNodeXml(String defId, String nodeId, T setting) throws Exception {
        String xml = this.getXml(defId, nodeId, setting);
        this.updateXml(defId, xml);
    }

    protected List<BpmNodeDef> getNodeList(String defId) throws Exception {
        ArrayList<BpmNodeDef> list = new ArrayList<BpmNodeDef>();
        List<BpmNodeDef> bpmNodeDefList = this.bpmDefinitionAccessor.getAllNodeDef(defId);
        for (BpmNodeDef bpmNodeDef : bpmNodeDefList) {
            if (!NodeType.START.equals((Object)bpmNodeDef.getType()) && !NodeType.USERTASK.equals((Object)bpmNodeDef.getType()) && !NodeType.CUSTOMSIGNTASK.equals((Object)bpmNodeDef.getType()) && !NodeType.SIGNTASK.equals((Object)bpmNodeDef.getType())) continue;
            list.add(bpmNodeDef);
        }
        return list;
    }
}

