package com.artfess.workflow.runtime.job;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.artfess.base.constants.SystemConstants;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.workflow.runtime.controller.BpmAutoStartConfController;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;

/**
 * 定时启动流程
 *
 * @company 阿特菲斯信息技术有限公司
 * @author jason
 * @email liygui@jee-soft.cn
 * @date 2020年5月28日
 */
@Component
public class FlowAutoStartXxlJob {
	@Resource
	BpmAutoStartConfController bpmAutoStartConfController;

	/**
     * 1、简单任务示例（Bean模式）
     */
    @XxlJob("flowAutoStartXxlJob")
    public ReturnT<String> flowAutoStartXxlJob(String param) throws Exception {
        XxlJobLogger.log("XXL-JOB, 开始执行流程自动发起任务.");
        String defaultAccount = SystemConstants.SYSTEM_ACCOUNT;
        
		JsonNode jsonNode = JsonUtil.toJsonNode(param);
		String startAccount = jsonNode.get("startAccount").asText();
		if (StringUtil.isNotEmpty(startAccount)) {
			defaultAccount = startAccount;
		}
		// 定时任务中没有当前登录用户，所以需要设置到当前用户上下文中
		ContextUtil.setCurrentUserByAccount(defaultAccount);

		// 调用接口启动流程
		ObjectNode startFlowResult = bpmAutoStartConfController.defAutoStart();
		if (BeanUtils.isNotEmpty(startFlowResult) && !startFlowResult.get("state").asBoolean()) {
			String message = "流程启动失败";
			if (BeanUtils.isNotEmpty(startFlowResult) && BeanUtils.isNotEmpty(startFlowResult.get("message"))) {
				message += ":" + startFlowResult.get("message").asText();
			}
			throw new BaseException(message);
		}
        return ReturnT.SUCCESS;
    }
	
}
