package com.artfess.workflow.bpmModel.controller;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.workflow.bpmModel.dao.BpmOftenFlowUserDao;
import com.artfess.workflow.bpmModel.manager.BpmOftenFlowManager;
import com.artfess.workflow.bpmModel.model.BpmOftenFlow;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 
 * <pre> 
 * 描述：通用流程 控制器类
 * 构建组：x7
 * 作者:liyg
 * 邮箱:liygui@jee-soft.cn
 * 日期:2019-03-04 15:23:03
 * 版权：广州宏天软件有限公司
 * </pre>
 */
@RestController
@RequestMapping("/bpmModel/BpmOftenFlow/v1")
@Api(tags="常用流程设置")
@ApiGroup(group= {ApiGroupConsts.GROUP_BPM})
public class BpmOftenFlowController extends BaseController<BpmOftenFlowManager, BpmOftenFlow>{

    @Resource
    BpmOftenFlowUserDao bpmOftenFlowUserDao;
	/**
	 * 通用流程列表(分页条件查询)数据
	 * @return
	 * @throws Exception 
	 * PageJson
	 * @exception 
	 */
	@PostMapping("/list")
	@ApiOperation(value="通用流程数据列表", httpMethod = "POST", notes = "获取通用流程列表")
	public PageList<BpmOftenFlow> list(@ApiParam(name="queryFilter",value="查询对象")@RequestBody QueryFilter<BpmOftenFlow> queryFilter) throws Exception{
        queryFilter.addFilter("USER_ID_", null, QueryOP.IS_NULL);
	    PageList<BpmOftenFlow> query = baseService.query(queryFilter);
		return query;
	}
	
	/**
	 * 通用流程明细页面
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/get/{id}")
	@ApiOperation(value="通用流程数据详情",httpMethod = "GET",notes = "通用流程数据详情")
	public BpmOftenFlow get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
		return baseService.get(id);
	}
	
    /**
	 * 新增通用流程
	 * @param map
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "新增,更新通用流程数据", httpMethod = "POST", notes = "新增,更新通用流程数据")
	public CommonResult<String> save(@ApiParam(name="map",value="参数", required = true)@RequestBody Map<String,Object> map) throws Exception{
        return baseService.saveOrUpdateCommonFlow(map);
	}

    @GetMapping(value="getBpmOftenFlowUsers")
    @ApiOperation(value="通过常用流程ID查询常用流程授权信息",httpMethod = "GET",notes = "通过常用流程ID查询常用流程授权信息")
    public String getBpmOftenFlowUsers(@ApiParam(name="oftenFlowId",value="业务对象主键", required = true)@RequestParam String oftenFlowId) throws Exception{
        return baseService.getBpmOftenFlowUsers(oftenFlowId);
    }
	
	/**
	 * 删除通用流程记录
	 * @param id
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="remove/{id}")
	@ApiOperation(value = "删除通用流程记录", httpMethod = "DELETE", notes = "删除通用流程记录")
	public  CommonResult<String>  remove(@ApiParam(name="id",value="业务主键", required = true)@PathVariable String id) throws Exception{
		baseService.remove(id);
		return new CommonResult<String>(true, "删除成功");
	}
	
	/**
	 * 批量删除通用流程记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/removes")
	@ApiOperation(value = "批量删除通用流程记录", httpMethod = "DELETE", notes = "批量删除通用流程记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		String msg = "批量删除成功";
		for(String id :ids){
            bpmOftenFlowUserDao.removeByOftenFlowId(id);//根据常用流程ID删除授权信息
        }
		baseService.removeByIds(ids);
		List<String> list = Arrays.asList(ids);
		if(list.size() == 1) {
			msg = "删除成功";
		}
		return new CommonResult<String>(true, msg);
	}
	
	/**
	 * 通用流程明细页面
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/getMyOftenFlowKey")
	@ApiOperation(value="获取我的常用流程key",httpMethod = "GET",notes = "获取我的常用流程key")
	public Set<String> getMyOftenFlowKey() throws Exception{
        QueryFilter<BpmOftenFlow> queryFilter = QueryFilter.<BpmOftenFlow>build();
        PageBean page = new PageBean(1,20);
        queryFilter.setPageBean(page);
        queryFilter.addFilter("USER_ID_", ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        //先按用户ID查询用户的常用流程
        PageList<BpmOftenFlow> query = baseService.query(queryFilter);
        //没有则查询管理端配置的默认常用流程
        if (query.getRows().size()==0) {
            query = baseService.customQuery(ContextUtil.getCurrentUserId());
        }
		Set<String> defKeySet = new HashSet<>();
		if (BeanUtils.isEmpty(query) || query.getRows().size()==0) {
			return defKeySet;
		}
		for (BpmOftenFlow flow : query.getRows()) {
			defKeySet.add(flow.getDefKey());
		}
		return defKeySet;
	}
	
	@PostMapping(value="saveMyOftenFlow")
	@ApiOperation(value = "保存我的常用流程", httpMethod = "POST", notes = "保存我的常用流程")
	public CommonResult<String> saveMyOftenFlow(@ApiParam(name="list",value="通用流程业务对象", required = true)@RequestBody ArrayNode list) throws Exception{
		IUser user = ContextUtil.getCurrentUser();
		baseService.saveMyFlow(user.getUserId(), user.getFullname(), list);
		return new CommonResult<String>("添加通用流程成功");
	}
}
