/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.script;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.groovy.IUserScript;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.uc.api.impl.model.Org;
import com.artfess.uc.api.impl.model.UserFacade;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.Group;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class OrgScript
implements IUserScript {
    @Resource
    UCFeignService ucFeignService;
    @Resource
    IUserService userService;

    private Set<BpmIdentity> convertUserList(List<IUser> list) {
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        for (IUser iUser : list) {
            if (!BeanUtils.isNotEmpty((Object)iUser) || iUser.getStatus() != 1) continue;
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setId(iUser.getUserId());
            bpmIdentity.setName(iUser.getFullname());
            bpmIdentity.setType("user");
            identitys.add((BpmIdentity)bpmIdentity);
        }
        return identitys;
    }

    private List<IUser> usersObjConvertToIusers(List<ObjectNode> objs) {
        ArrayList<IUser> list = new ArrayList<IUser>();
        if (BeanUtils.isNotEmpty(objs)) {
            for (ObjectNode obj : objs) {
                UserFacade user = new UserFacade();
                user.setId(obj.get("id").asText());
                user.setAccount(obj.get("account").asText());
                user.setFullname(obj.get("fullname").asText());
                user.setUserId(obj.get("id").asText());
                user.setStatus(Integer.valueOf(obj.get("status").asInt()));
                list.add((IUser)user);
            }
        }
        return list;
    }

    private IGroup getUserMainGroup(String userId, String demCode) {
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        ObjectNode orgObj = service.getMainGroup(userId, demCode);
        try {
            if (BeanUtils.isNotEmpty((Object)orgObj)) {
                boolean isParent = orgObj.get("isParent").asBoolean();
                orgObj.put("isIsParent", isParent ? 1 : 0);
                orgObj.remove("isParent");
                IGroup org = (IGroup)JsonUtil.toBean((JsonNode)orgObj, Org.class);
                return org;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Set<BpmIdentity> getChargesByPOrg(Boolean isMain, String demCode) throws JsonParseException, JsonMappingException, IOException {
        List users;
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        IGroup group = this.getUserMainGroup(ContextUtil.getCurrentUserId(), demCode);
        if (BeanUtils.isNotEmpty((Object)group) && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getChargesByOrgId(group.getParentId(), isMain.booleanValue())))) {
            List<IUser> list = this.usersObjConvertToIusers(users);
            identitys = this.convertUserList(list);
        }
        return identitys;
    }

    public Set<BpmIdentity> getChargesByStartPOrg(Boolean isMain, String demCode) throws JsonParseException, JsonMappingException, IOException {
        List users;
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = (String)taskCmd.getVariables().get("startUser");
        IGroup group = this.getUserMainGroup(userId, demCode);
        if (BeanUtils.isNotEmpty((Object)group) && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getChargesByOrgId(group.getParentId(), isMain.booleanValue())))) {
            List<IUser> list = this.usersObjConvertToIusers(users);
            identitys = this.convertUserList(list);
        }
        return identitys;
    }

    public boolean isContainsJob(String orgReldefCode) {
        if (StringUtil.isEmpty((String)orgReldefCode)) {
            return false;
        }
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = (String)taskCmd.getVariables().get("startUser");
        ArrayNode reldefs = (ArrayNode)this.ucFeignService.getJobsByUserId(userId);
        for (JsonNode jsonNode : reldefs) {
            ObjectNode job = (ObjectNode)jsonNode;
            if (!orgReldefCode.equals(job.get("code").asText())) continue;
            return true;
        }
        return false;
    }

    public boolean isSupOrgByCurrMain(int level) {
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = (String)taskCmd.getVariables().get("startUser");
        return this.ucFeignService.isSupOrgByCurrMain(userId, null, Integer.valueOf(level));
    }

    public boolean isSupOrgByCurrMain(String demCode) throws IOException {
        IGroup group = this.getUserMainGroup(ContextUtil.getCurrentUserId(), demCode);
        return StringUtil.isNotZeroEmpty((String)group.getParentId());
    }

    public Set<BpmIdentity> getChargesByOrg(boolean isMain, String demCode) throws IOException {
        List users;
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        IGroup group = this.getUserMainGroup(ContextUtil.getCurrentUserId(), demCode);
        if (BeanUtils.isNotEmpty((Object)group) && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getChargesByOrgId(group.getGroupId(), isMain)))) {
            List<IUser> list = this.usersObjConvertToIusers(users);
            identitys = this.convertUserList(list);
        }
        return identitys;
    }

    public Set<BpmIdentity> getChargesByStartOrg(Boolean isMain, String demCode) {
        List users;
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = (String)taskCmd.getVariables().get("startUser");
        ObjectNode org = this.ucFeignService.getMainGroup(userId, demCode);
        if (BeanUtils.isNotEmpty((Object)org) && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getChargesByOrgId(org.get("groupId").asText(), isMain.booleanValue())))) {
            List<IUser> list = this.usersObjConvertToIusers(users);
            identitys = this.convertUserList(list);
        }
        return identitys;
    }

    public Set<BpmIdentity> getChargesByOrgCode(String code, Boolean isMain) {
        List users;
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ObjectNode org = this.ucFeignService.getOrgByIdOrCode(code);
        if (BeanUtils.isNotEmpty((Object)org) && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getChargesByOrgId(org.get("groupId").asText(), isMain.booleanValue())))) {
            List<IUser> list = this.usersObjConvertToIusers(users);
            identitys = this.convertUserList(list);
        }
        return identitys;
    }

    public Set<BpmIdentity> getByOrgRelDefCode(String orgCode, String redDefCode) {
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        if (StringUtil.isNotEmpty((String)orgCode) && StringUtil.isNotEmpty((String)redDefCode)) {
            String[] orgCodeArray = orgCode.split(",");
            ArrayList users = new ArrayList();
            for (String ocode : orgCodeArray) {
                try {
                    List userList = this.ucFeignService.getByOrgRelDefCode(redDefCode, ocode);
                    if (!BeanUtils.isNotEmpty((Object)userList)) continue;
                    users.addAll(userList);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (BeanUtils.isNotEmpty(users)) {
                for (ObjectNode obj : users) {
                    DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
                    bpmIdentity.setType("user");
                    bpmIdentity.setId(obj.get("id").asText());
                    bpmIdentity.setName(obj.get("name").asText());
                    identitys.add((BpmIdentity)bpmIdentity);
                }
            }
        }
        return identitys;
    }

    public Set<BpmIdentity> getByOrgRelCode(String orgCode, String relCode) {
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        if (StringUtil.isNotEmpty((String)orgCode) && StringUtil.isNotEmpty((String)orgCode)) {
            List orgUsers = new ArrayList();
            try {
                orgUsers = this.ucFeignService.getByOrgRelCode(orgCode, relCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (BeanUtils.isNotEmpty(orgUsers)) {
                ArrayList<IUser> list = new ArrayList<IUser>();
                for (ObjectNode obj : orgUsers) {
                    IUser iUser = this.userService.getUserById(obj.get("USER_ID_").asText());
                    list.add(iUser);
                }
                identitys = this.convertUserList(list);
            }
        }
        return identitys;
    }

    public Set<BpmIdentity> getMasterFromUnder(String demId) throws JsonParseException, JsonMappingException, IOException {
        return this.getMasterFromUnderByUser(ContextUtil.getCurrentUserId(), demId);
    }

    public Set<BpmIdentity> getMasterFromUnderByStart(String demId) throws JsonParseException, JsonMappingException, IOException {
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isNotEmpty((Object)taskCmd)) {
            String userId = (String)taskCmd.getVariables().get("startUser");
            identitys = this.getMasterFromUnderByUser(userId, demId);
        }
        return identitys;
    }

    public Set<BpmIdentity> getMasterFromUnderByUser(String userId, String demId) {
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ArrayNode arry = this.ucFeignService.getSuperFromUnder(userId, demId);
        if (BeanUtils.isNotEmpty((Object)arry)) {
            ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
            for (JsonNode jsonNode : arry) {
                list.add((ObjectNode)jsonNode);
            }
            List<IUser> users = this.usersObjConvertToIusers(list);
            identitys = this.convertUserList(users);
        }
        return identitys;
    }

    public Set<BpmIdentity> getCustomLevelCharge(String level, boolean isMainCharge) {
        ArrayNode arry;
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = ContextUtil.getCurrentUserId();
        if (BeanUtils.isNotEmpty((Object)taskCmd)) {
            userId = (String)taskCmd.getVariables().get("startUser");
        }
        if (BeanUtils.isNotEmpty((Object)(arry = this.ucFeignService.getCustomLevelCharge(userId, level, isMainCharge)))) {
            ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
            for (JsonNode jsonNode : arry) {
                list.add((ObjectNode)jsonNode);
            }
            List<IUser> users = this.usersObjConvertToIusers(list);
            identitys = this.convertUserList(users);
        }
        return identitys;
    }

    public Set<BpmIdentity> getCustomLevelPost(String level, String postCode) throws JsonParseException, JsonMappingException, IOException {
        Set arry;
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = ContextUtil.getCurrentUserId();
        if (BeanUtils.isNotEmpty((Object)taskCmd)) {
            userId = (String)taskCmd.getVariables().get("startUser");
        }
        if (BeanUtils.isNotEmpty((Object)(arry = this.ucFeignService.getCustomLevelPost(userId, level, postCode)))) {
            ArrayList<IUser> users = new ArrayList<IUser>();
            for (JsonNode jsonNode : arry) {
                UserFacade user = new UserFacade();
                user.setId(jsonNode.get("id").asText());
                user.setFullname(jsonNode.get("name").asText());
                user.setStatus(Integer.valueOf(1));
                users.add((IUser)user);
            }
            identitys = this.convertUserList(users);
        }
        return identitys;
    }

    public Set<BpmIdentity> getCustomLevelJob(String level, String jobCode) throws JsonParseException, JsonMappingException, IOException {
        Set arry;
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = ContextUtil.getCurrentUserId();
        if (BeanUtils.isNotEmpty((Object)taskCmd)) {
            userId = (String)taskCmd.getVariables().get("startUser");
        }
        if (BeanUtils.isNotEmpty((Object)(arry = this.ucFeignService.getCustomLevelJob(userId, level, jobCode)))) {
            ArrayList<IUser> users = new ArrayList<IUser>();
            for (JsonNode jsonNode : arry) {
                UserFacade user = new UserFacade();
                user.setId(jsonNode.get("id").asText());
                user.setFullname(jsonNode.get("name").asText());
                user.setStatus(Integer.valueOf(1));
                users.add((IUser)user);
            }
            identitys = this.convertUserList(users);
        }
        return identitys;
    }

    public String getStartOrgParam(String param) throws JsonParseException, JsonMappingException, IOException {
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = ContextUtil.getCurrentUserId();
        if (BeanUtils.isNotEmpty((Object)taskCmd)) {
            userId = (String)taskCmd.getVariables().get("startUser");
        }
        String value = this.ucFeignService.getStartOrgParam(userId, param);
        return value;
    }

    public IGroup getParentMainOrg(String grade) throws IOException {
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        Group org = new Group();
        Map map = service.getParentMainOrg(ContextUtil.getCurrentUserId());
        if (map.containsKey(grade)) {
            org = (IGroup)JsonUtil.toBean((String)JsonUtil.toJson(map.get(grade)), Org.class);
        }
        return org;
    }

    public String getParamMainOrgId(String grade) throws IOException {
        return this.getParentMainOrg(grade).getGroupId();
    }

    public String getParamKey(String orgId, String alias) throws IOException {
        return this.ucFeignService.getParamKey(orgId, alias);
    }

    public boolean isOrgHasParamKey(String orgId, String alias) throws Exception {
        return this.ucFeignService.isOrgHasParamKey(orgId, alias);
    }

    public boolean hasParamKey(String grade, String alias) throws IOException {
        return this.ucFeignService.hasOrgParamKey(grade, ContextUtil.getCurrentUserId(), alias);
    }
}

