package com.artfess.uc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @Author: wsf
 * @Description: 审核日志记录VO
 * @DateTime: 2025/2/11 15:42
 **/
@Data
public class UserApprovalRecordVO {

    @ApiModelProperty(value = "主键ID")
    private String id;

    @ApiModelProperty(value = "用户ID")
    private String userId;

    @ApiModelProperty(value = "审批节点")
    private String approvalNode;

    @ApiModelProperty(value = "处理人")
    private String approvalUserName;

    @ApiModelProperty(value = "审批时间")
    private LocalDateTime approvalDate;

    @ApiModelProperty(value = "办理时间")
    private Long processingTime;

    @ApiModelProperty(value = "审批意见")
    private String intranetPort;

    @ApiModelProperty(value = "审批结果（0：驳回，1:同意,3:发起,4:待发起）")
    private Integer approvalResult;
}
