package com.artfess.security.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DESUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.security.dao.SysAuthorizationDao;
import com.artfess.security.manager.SysAuthorizationManager;
import com.artfess.security.model.SysAuthorization;
import com.artfess.security.util.AuthorCheck;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

@Service("systemAuthorizationManager")
public class SysAuthorizationManagerImpl extends BaseManagerImpl<SysAuthorizationDao, SysAuthorization> implements SysAuthorizationManager {

    @Resource
    SysAuthorizationManager systemAuthorizationManager;

    @Resource
    SysAuthorizationDao sysAuthorizationDao;
    @Resource
    SystemConfigFeignService systemConfigFeignService;

    /**
     * 项目根目录
     */
    public static final String ROOT_PATH = System.getProperty("user.dir");

    /**
     * 模板下载、文件导入临时文件目录名
     */
    public static final String DATA_TEMP_FILE = "tempFile";

    /**
     * 模板下载、文件导入临时文件目录
     */
    public static final String TEMP_DATA_EXCEL = ROOT_PATH + File.separator + DATA_TEMP_FILE;

    //根据单位ID查询授权码，并产生文件，，返回文件路径
    public String createDesFile(String id) throws Exception {
        QueryWrapper<SysAuthorization> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("id_", id);
        SysAuthorization entity = this.systemAuthorizationManager.getOne(queryWrapper);
        entity.setDeptName(DESUtils.myEncrypt(entity.getDeptName()));
        entity.setVersionCode(DESUtils.myEncrypt(entity.getVersionCode()));
        entity.setType(DESUtils.myEncrypt(entity.getType()));//1临时 2永久
        entity.setInstallDate(DESUtils.myEncrypt(entity.getInstallDate()));
        entity.setEndDate(DESUtils.myEncrypt(entity.getEndDate()));
        entity.setUser(DESUtils.myEncrypt(entity.getUser()));//用户数限制 -1不限制
        entity.setOgnNum(DESUtils.myEncrypt(entity.getOgnNum()));
        entity.setTenantNum(DESUtils.myEncrypt(entity.getTenantNum()));
        entity.setUserNum(DESUtils.myEncrypt(entity.getUserNum()));
        entity.setSystemType(DESUtils.myEncrypt(entity.getSystemType()));
        String saveFile = TEMP_DATA_EXCEL + File.separator + id + ".lic";

        File file1 = new File(TEMP_DATA_EXCEL);
        if (!file1.exists()) {
            file1.mkdirs();
        }
        File file = new File(saveFile);
        if (!file.exists()) {
            file.createNewFile();
        }
        //序列化对象到文件中
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
        oos.writeObject(entity);
        oos.close();

        return saveFile;
    }

    /**
     * 进行写入 内容不被覆盖 追加写入
     *
     * @throws IOException
     */
    public static void writeFile(String saveFile, String content) {
        try {
            FileWriter fw = new FileWriter(saveFile, true);
            fw.write(content);
            fw.flush();
            fw.close();
        } catch (Exception e) {
            //
            e.printStackTrace();
        }
    }

    //写入txt内容 覆盖原内容
    public static void writetxtfile(String filepath, String content) {
        try {
            File file = new File(filepath);
            if (!file.exists()) {
                file.createNewFile();
            }
            //写入的txt文档的路径
            PrintWriter pw = new PrintWriter(filepath);
            //写入的内容
            pw.write(content);
            pw.flush();
            pw.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //读文件
    public static String readTxtFunc(String fileName) {
        String fileContent = "";
        try {
            File f = new File(fileName);
            if (f.isFile() && f.exists()) {
                InputStreamReader read = new InputStreamReader(new FileInputStream(f), "UTF-8");
                BufferedReader reader = new BufferedReader(read);
                String line;
                while ((line = reader.readLine()) != null) {
                    fileContent += line;
                }
                read.close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.print(fileContent);
        return fileContent;
    }

    public Map<String, String> uploadSystemAuthCode(String path) {
        //读取新文件的内容
        String content = readTxtFunc(path);
        org.springframework.core.io.Resource resource = new ClassPathResource(AuthorCheck.FILE_PATH);
        File file = null;
        try {
            file = resource.getFile();
        } catch (IOException e) {

        }
        //覆盖源文件的内容
        writetxtfile(file.getPath(), content);

        return AuthorCheck.getMapInfo();
    }

    //系统启动的时候默认生成一个临时授权文件，存储在磁盘上
    public void systemStartCreateFile() throws Exception {
        SysAuthorization entity = new SysAuthorization();
        entity.setDeptName(DESUtils.myEncrypt("试用单位"));
        entity.setVersionCode(DESUtils.myEncrypt("试用版"));
        entity.setType(DESUtils.myEncrypt("1"));//1临时 2永久
        entity.setInstallDate(DESUtils.myEncrypt(DateUtils.formatDate()));
        entity.setEndDate(DESUtils.myEncrypt(DateUtils.formatAddDayDate(90)));
        entity.setUser(DESUtils.myEncrypt("10"));//用户数限制 -1不限制
        entity.setOgnNum(DESUtils.myEncrypt("1"));
        entity.setTenantNum(DESUtils.myEncrypt("1"));
        entity.setUserNum(DESUtils.myEncrypt("10"));
        entity.setSystemType(DESUtils.myEncrypt("test"));
        String saveFile = AuthorCheck.FILE_PATH;//SystemConstants.TEMP_DATA_EXCEL+File.separator+"edp.data";

        File file1 = new File(TEMP_DATA_EXCEL);
        if (!file1.exists()) {
            file1.mkdirs();
        }
        File file = new File(saveFile);
        if (!file.exists()) {
            file.createNewFile();
        } else {
            //如果存在就不创建了
            return;
        }
        //序列化对象到文件中
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
        oos.writeObject(entity);
        oos.close();

    }

    //客户产生需要发送的lic文件
    public String systemCreateFile() throws Exception {
        ObjectNode basic = this.systemConfigFeignService.getCommonBasicOne();
        if (basic != null) {
            SysAuthorization entity = new SysAuthorization();
            entity.setDeptName(DESUtils.myEncrypt(basic.get("sysName").asText()));
            entity.setVersionCode(DESUtils.myEncrypt(null == basic.get("sysVersion") ? "试用版" : basic.get("sysVersion").asText()));
            entity.setType(DESUtils.myEncrypt("1"));//1临时 2永久
            entity.setTel(DESUtils.myEncrypt(null == basic.get("sysCompanyPhone") ? "" : basic.get("sysCompanyPhone").asText()));
            entity.setInstallDate(DESUtils.myEncrypt(DateUtils.formatDate()));
            entity.setEndDate(DESUtils.myEncrypt(DateUtils.formatAddDayDate(90)));
            entity.setUser(DESUtils.myEncrypt(null == basic.get("sysCompanyLegal") ? "临时用户" : basic.get("sysCompanyLegal").asText()));
            entity.setOgnNum(DESUtils.myEncrypt("1"));
            entity.setTenantNum(DESUtils.myEncrypt("1"));
            entity.setUserNum(DESUtils.myEncrypt("10"));//用户数限制 0不限制
            entity.setSystemType(DESUtils.myEncrypt("test"));
            String saveFile = AuthorCheck.FILE_PATH_LIC;//SystemConstants.TEMP_DATA_EXCEL+File.separator+"edp.data";

            File file1 = new File(TEMP_DATA_EXCEL);
            if (!file1.exists()) {
                file1.mkdirs();
            }
            File file = new File(saveFile);
            file.createNewFile();
            //序列化对象到文件中
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveFile));
            oos.writeObject(entity);
            oos.close();

            return saveFile;
        } else {
            return null;
        }

    }

    public SysAuthorization getByName(String deptName) {
        QueryWrapper<SysAuthorization> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotBlank(deptName), "DEPT_NAME_", deptName);
        List<SysAuthorization> sysAuthorizations = this.sysAuthorizationDao.selectList(queryWrapper);
        if (sysAuthorizations.size() > 0) {
            return sysAuthorizations.get(0);
        }
        return null;
    }

}
