/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.util;

import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.uc.dao.PropertiesDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserRelManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.Properties;
import com.artfess.uc.model.User;
import com.artfess.uc.params.common.OrgExportObject;
import com.artfess.uc.params.group.GroupIdentity;
import com.artfess.uc.params.user.UserVo;
import com.cronutils.builder.CronBuilder;
import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronConstraintsFactory;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.FieldExpressionFactory;
import com.cronutils.model.field.expression.Weekdays;
import com.cronutils.model.field.value.SpecialChar;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

public class OrgUtil {
    public static List<User> getUserListByTypeId(String type, String idStr) throws Exception {
        ArrayList<User> list = new ArrayList<User>();
        UserManager userManager = (UserManager)AppUtil.getBean(UserManager.class);
        if (StringUtil.isNotEmpty((String)idStr)) {
            String[] ids;
            for (String id : ids = idStr.split(",")) {
                List<User> listJob;
                if (!StringUtil.isNotEmpty((String)id)) continue;
                if ("user".equals(type)) {
                    User user = (User)userManager.get((Serializable)((Object)id));
                    if (!BeanUtils.isNotEmpty((Object)user)) continue;
                    list.add(user);
                    continue;
                }
                if ("org".equals(type)) {
                    List<User> listOrg = userManager.getUserListByOrgId(id);
                    if (!BeanUtils.isNotEmpty(listOrg)) continue;
                    list.addAll(listOrg);
                    continue;
                }
                if ("role".equals(type)) {
                    List<User> listRole = userManager.getUserListByRoleId(id);
                    if (!BeanUtils.isNotEmpty(listRole)) continue;
                    list.addAll(listRole);
                    continue;
                }
                if ("pos".equals(type)) {
                    List<User> listPos = userManager.getListByPostId(id);
                    if (!BeanUtils.isNotEmpty(listPos)) continue;
                    list.addAll(listPos);
                    continue;
                }
                if (!"job".equals(type) || !BeanUtils.isNotEmpty(listJob = userManager.getListByJobId(id))) continue;
                list.addAll(listJob);
            }
        }
        return list;
    }

    public static void removeDuplicate(List<User> users) {
        if (BeanUtils.isNotEmpty(users)) {
            for (int i = 0; i < users.size() - 1; ++i) {
                for (int j = users.size() - 1; j > i; --j) {
                    if (!users.get(j).getAccount().equals(users.get(i).getAccount())) continue;
                    users.remove(j);
                }
            }
        }
    }

    public static <E> void removeDuplicate(List<E> objects, String field) {
        if (BeanUtils.isNotEmpty(objects)) {
            for (int i = 0; i < objects.size() - 1; ++i) {
                for (int j = objects.size() - 1; j > i; --j) {
                    if (!OrgUtil.getValueByKey(objects.get(j), field).equals(OrgUtil.getValueByKey(objects.get(i), field))) continue;
                    objects.remove(j);
                }
            }
        }
    }

    public static Set<GroupIdentity> convertToGroupIdentity(List<User> users) throws IOException {
        HashSet<GroupIdentity> identitys;
        block4: {
            identitys = new HashSet<GroupIdentity>();
            if (!BeanUtils.isNotEmpty(users)) break block4;
            if (users.get(0) instanceof User) {
                for (User user : users) {
                    GroupIdentity identity = new GroupIdentity();
                    identity.setId(user.getId());
                    identity.setCode(user.getAccount());
                    identity.setName(user.getFullname());
                    identity.setGroupType("user");
                    identitys.add(identity);
                }
            } else {
                for (User obj : users) {
                    ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode((Object)obj);
                    GroupIdentity identity = new GroupIdentity();
                    identity.setId(jsonObj.get("id_").toString());
                    identity.setCode(jsonObj.get("account_").toString());
                    identity.setName(jsonObj.get("fullname_").toString());
                    identity.setGroupType("user");
                    identitys.add(identity);
                }
            }
        }
        return identitys;
    }

    public static UserVo convertToUserVo(User user) {
        if (BeanUtils.isEmpty((Object)user)) {
            return null;
        }
        return new UserVo(user);
    }

    public static List<UserVo> convertToUserVoList(List<User> users) {
        ArrayList<UserVo> list = new ArrayList<UserVo>();
        for (User user : users) {
            list.add(OrgUtil.convertToUserVo(user));
        }
        return list;
    }

    public static boolean isContains(String ids, String id) {
        if (StringUtil.isNotEmpty((String)ids) && StringUtil.isNotEmpty((String)id)) {
            return ids.contains(id);
        }
        return false;
    }

    public static Object getValueByKey(Object obj, String key) {
        Class<?> userCla = obj.getClass();
        Field[] fs = userCla.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            Field f = fs[i];
            f.setAccessible(true);
            try {
                if (!f.getName().endsWith(key)) continue;
                return f.get(obj);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static CommonResult<Integer> getRemovePhysiMsg(Integer num) {
        return new CommonResult(true, String.format("\u6210\u529f\u5220\u9664%s\u6761\u8bb0\u5f55", (int)num), (Object)num);
    }

    public static String[] toStringArray(List<String> array) {
        if (BeanUtils.isNotEmpty(array)) {
            String[] strs = new String[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                strs[i] = array.get(i);
            }
            return strs;
        }
        return null;
    }

    public static QueryFilter getDataByTimeFilter(String btimeStr, String etimeStr) throws ParseException {
        LocalDateTime etime;
        QueryFilter filter = QueryFilter.build();
        LocalDateTime btime = StringUtil.isNotEmpty((String)btimeStr) ? DateFormatUtil.parse((String)btimeStr) : null;
        LocalDateTime localDateTime = etime = StringUtil.isNotEmpty((String)etimeStr) ? DateFormatUtil.parse((String)etimeStr) : null;
        if (BeanUtils.isNotEmpty((Object)etime) && etimeStr.indexOf(":") < 0) {
            etime = DateUtil.setAsEnd((LocalDateTime)etime);
        }
        if (BeanUtils.isNotEmpty((Object)btime) && BeanUtils.isNotEmpty((Object)etime)) {
            if (DateUtil.getTime((LocalDateTime)btime, (LocalDateTime)etime) < 0L) {
                throw new RuntimeException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            ArrayList<LocalDateTime> list = new ArrayList<LocalDateTime>();
            list.add(btime);
            list.add(etime);
            filter.addFilter("UPDATE_TIME_", list, QueryOP.BETWEEN, FieldRelation.AND);
        } else {
            if (BeanUtils.isNotEmpty((Object)btime)) {
                filter.addFilter("UPDATE_TIME_", (Object)btime, QueryOP.GREAT_EQUAL, FieldRelation.AND);
            }
            if (BeanUtils.isNotEmpty((Object)etime)) {
                filter.addFilter("UPDATE_TIME_", (Object)etime, QueryOP.LESS_EQUAL, FieldRelation.AND);
            }
        }
        return filter;
    }

    public static String getSubInSql(Object value, String splitStr) {
        if (value instanceof String) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            StringTokenizer st = new StringTokenizer(value.toString(), splitStr);
            while (st.hasMoreTokens()) {
                sb.append("'");
                sb.append(st.nextToken());
                sb.append("'");
                sb.append(",");
            }
            sb = new StringBuilder(sb.substring(0, sb.length() - 1));
            sb.append(")");
            return sb.toString();
        }
        if (value instanceof List) {
            List objList = (List)value;
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (Object obj : objList) {
                sb.append("\"");
                sb.append(obj.toString());
                sb.append("\"");
                sb.append(",");
            }
            sb = new StringBuilder(sb.substring(0, sb.length() - 1));
            sb.append(")");
            return sb.toString();
        }
        if (value instanceof String[]) {
            String[] objList = (String[])value;
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (String obj : objList) {
                sb.append("\"");
                sb.append(obj.toString());
                sb.append("\"");
                sb.append(",");
            }
            sb = new StringBuilder(sb.substring(0, sb.length() - 1));
            sb.append(")");
            return sb.toString();
        }
        return "";
    }

    public static void getOrgParams(QueryFilter queryFilter, OrgExportObject exportObject) throws Exception {
        exportObject.setBtime(null);
        exportObject.setEtime(null);
        OrgManager orgService = (OrgManager)AppUtil.getBean(OrgManager.class);
        List<Org> orgs = orgService.getOrgByTime(exportObject);
        if (BeanUtils.isNotEmpty(orgs)) {
            ArrayList<String> orgIds = new ArrayList<String>();
            for (Org org : orgs) {
                orgIds.add(org.getId());
            }
            queryFilter.addFilter("ORG_ID_", orgIds, QueryOP.IN, FieldRelation.AND);
        }
    }

    public static boolean checkUserGruopIsUserRel(String type, String value) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("GROUP_TYPE_", (Object)type, QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("VALUE_", (Object)value, QueryOP.EQUAL, FieldRelation.AND);
        UserRelManager userRelService = (UserRelManager)AppUtil.getBean(UserRelManager.class);
        return userRelService.query(queryFilter).getRows().size() > 0;
    }

    public static User getCurrentUser() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated() && !(auth instanceof AnonymousAuthenticationToken)) {
            UserDetailsService userDetailsService;
            UserDetails user;
            Object details = auth.getPrincipal();
            String account = null;
            if (details != null && details instanceof UserDetails) {
                account = ((UserDetails)details).getUsername();
            }
            if ((user = (userDetailsService = (UserDetailsService)AppUtil.getBean(UserDetailsService.class)).loadUserByUsername(account)) instanceof User) {
                User userVo = (User)user;
                return userVo;
            }
        }
        return null;
    }

    public static String getScheduledCron(String jsonStr) throws IOException {
        String cronStr = "";
        if (StringUtil.isNotEmpty((String)jsonStr)) {
            ObjectNode json = (ObjectNode)JsonUtil.toJsonNode((String)jsonStr);
            String time = json.get("time").toString();
            String minute = json.findValue("minute") != null ? json.get("minute").toString() : "0";
            String hour = json.findValue("hour") != null ? json.get("hour").toString() : "0";
            String day = json.findValue("day") != null ? json.get("day").toString() : "0";
            String week = json.findValue("week") != null ? json.get("week").toString() : "0";
            String type = json.get("triggerType").toString();
            CronDefinition cronDefinition = CronDefinitionBuilder.defineCron().withSeconds().and().withMinutes().and().withHours().and().withDayOfMonth().supportsL().supportsW().supportsLW().supportsQuestionMark().and().withMonth().and().withDayOfWeek().withValidRange(1, 7).withMondayDoWValue(2).supportsHash().supportsL().supportsQuestionMark().and().withCronValidation(CronConstraintsFactory.ensureEitherDayOfWeekOrDayOfMonth()).instance();
            CronBuilder builder = null;
            switch (type) {
                case "cron": {
                    cronStr = json.get("cron").toString();
                    break;
                }
                case "time": {
                    builder = CronBuilder.cron((CronDefinition)cronDefinition).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withDoM((FieldExpression)FieldExpressionFactory.always()).withHour((FieldExpression)FieldExpressionFactory.always()).withMinute((FieldExpression)FieldExpressionFactory.every((FieldExpression)FieldExpressionFactory.on((int)0), (int)Integer.valueOf(time))).withSecond((FieldExpression)FieldExpressionFactory.on((int)0));
                    break;
                }
                case "day": {
                    builder = CronBuilder.cron((CronDefinition)cronDefinition).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withDoM((FieldExpression)FieldExpressionFactory.always()).withHour((FieldExpression)FieldExpressionFactory.on((int)Integer.valueOf(hour))).withMinute((FieldExpression)FieldExpressionFactory.on((int)Integer.valueOf(minute))).withSecond((FieldExpression)FieldExpressionFactory.on((int)0));
                    break;
                }
                case "week": {
                    builder = CronBuilder.cron((CronDefinition)cronDefinition).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.and(OrgUtil.buildWeekdays(week))).withDoM((FieldExpression)FieldExpressionFactory.questionMark()).withHour((FieldExpression)FieldExpressionFactory.on((int)Integer.valueOf(hour))).withMinute((FieldExpression)FieldExpressionFactory.on((int)Integer.valueOf(minute))).withSecond((FieldExpression)FieldExpressionFactory.on((int)0));
                    break;
                }
                case "month": {
                    builder = CronBuilder.cron((CronDefinition)cronDefinition).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withDoM((FieldExpression)FieldExpressionFactory.and(OrgUtil.builddays(day))).withHour((FieldExpression)FieldExpressionFactory.on((int)Integer.valueOf(hour))).withMinute((FieldExpression)FieldExpressionFactory.on((int)Integer.valueOf(minute))).withSecond((FieldExpression)FieldExpressionFactory.on((int)0));
                    break;
                }
            }
            if (BeanUtils.isNotEmpty(builder)) {
                Cron cron = builder.instance();
                cronStr = cron.asString();
                if ("week".equals(type)) {
                    cronStr = OrgUtil.transCronWeek(cronStr);
                }
            }
        }
        return cronStr;
    }

    private static String transCronWeek(String cronStr) {
        String[] strs = cronStr.split(" ");
        String weekStr = strs[strs.length - 1];
        String[] weeks = weekStr.split(",");
        StringBuilder weekBuilder = new StringBuilder();
        String[] stringArray = weeks;
        int n = stringArray.length;
        block18: for (int i = 0; i < n; ++i) {
            String week;
            switch (week = stringArray[i]) {
                case "1": {
                    weekBuilder.append(",MON");
                    continue block18;
                }
                case "2": {
                    weekBuilder.append(",TUE");
                    continue block18;
                }
                case "3": {
                    weekBuilder.append(",WED");
                    continue block18;
                }
                case "4": {
                    weekBuilder.append(",THU");
                    continue block18;
                }
                case "5": {
                    weekBuilder.append(",FRI");
                    continue block18;
                }
                case "6": {
                    weekBuilder.append(",SAT");
                    continue block18;
                }
                case "7": {
                    weekBuilder.append(",SUN");
                    continue block18;
                }
            }
        }
        String weekBuilderStr = weekBuilder.toString();
        if (weekBuilderStr.startsWith(",")) {
            weekBuilderStr = weekBuilderStr.replaceFirst(",", "");
            cronStr = cronStr.replace(weekStr, weekBuilderStr);
        }
        return cronStr;
    }

    private static List<FieldExpression> buildWeekdays(String str) throws IOException {
        ArrayList<FieldExpression> list = new ArrayList<FieldExpression>();
        ArrayNode split = (ArrayNode)JsonUtil.toJsonNode((String)str);
        for (Object object : split) {
            switch (object.toString()) {
                case "MON": {
                    list.add((FieldExpression)FieldExpressionFactory.on((int)Weekdays.MONDAY.getWeekday()));
                    break;
                }
                case "TUE": {
                    list.add((FieldExpression)FieldExpressionFactory.on((int)Weekdays.TUESDAY.getWeekday()));
                    break;
                }
                case "WED": {
                    list.add((FieldExpression)FieldExpressionFactory.on((int)Weekdays.WEDNESDAY.getWeekday()));
                    break;
                }
                case "THU": {
                    list.add((FieldExpression)FieldExpressionFactory.on((int)Weekdays.THURSDAY.getWeekday()));
                    break;
                }
                case "FRI": {
                    list.add((FieldExpression)FieldExpressionFactory.on((int)Weekdays.FRIDAY.getWeekday()));
                    break;
                }
                case "SAT": {
                    list.add((FieldExpression)FieldExpressionFactory.on((int)Weekdays.SATURDAY.getWeekday()));
                    break;
                }
                case "SUN": {
                    list.add((FieldExpression)FieldExpressionFactory.on((int)Weekdays.SUNDAY.getWeekday()));
                    break;
                }
            }
        }
        return list;
    }

    private static List<FieldExpression> builddays(String str) throws IOException {
        ArrayList<FieldExpression> list = new ArrayList<FieldExpression>();
        ArrayNode split = (ArrayNode)JsonUtil.toJsonNode((String)str);
        for (Object object : split) {
            if (!"L".equals(object.toString())) {
                list.add((FieldExpression)FieldExpressionFactory.on((int)Integer.valueOf(object.toString())));
                continue;
            }
            list.add((FieldExpression)FieldExpressionFactory.on((SpecialChar)SpecialChar.L));
        }
        return list;
    }

    public static String getScheduledCronLog(String jsonStr) throws IOException {
        String cronStr = "";
        if (StringUtil.isNotEmpty((String)jsonStr)) {
            String type;
            ObjectNode json = (ObjectNode)JsonUtil.toJsonNode((String)jsonStr);
            String time = json.get("time").toString();
            String minute = json.findValue("minute") != null ? json.get("minute").toString() : "0";
            String hour = json.findValue("hour") != null ? json.get("hour").toString() : "0";
            String day = json.findValue("day") != null ? json.get("day").toString() : "0";
            String week = json.findValue("week") != null ? json.get("week").toString() : "0";
            switch (type = json.get("triggerType").toString()) {
                case "cron": {
                    cronStr = "Cron\u8868\u8fbe\u5f0f\u3010" + json.get("cron") + "\u3011";
                    break;
                }
                case "time": {
                    cronStr = "\u6bcf" + time + "\u5206\u949f\u6267\u884c\u4e00\u6b21";
                    break;
                }
                case "day": {
                    cronStr = "\u6bcf\u5929" + hour + "\u65f6" + minute + "\u5206\u6267\u884c";
                    break;
                }
                case "week": {
                    cronStr = "\u6bcf" + OrgUtil.buildWeekdaysLog(week) + "\u7684" + hour + "\u65f6" + minute + "\u5206\u6267\u884c";
                    break;
                }
                case "month": {
                    cronStr = "\u6bcf\u6708" + OrgUtil.builddaysLog(day) + "\u7684" + hour + "\u65f6" + minute + "\u5206\u6267\u884c";
                    break;
                }
            }
        }
        return cronStr;
    }

    private static String buildWeekdaysLog(String str) throws IOException {
        StringBuilder weeks = new StringBuilder();
        ArrayNode split = (ArrayNode)JsonUtil.toJsonNode((String)str);
        for (Object object : split) {
            switch (object.toString()) {
                case "MON": {
                    weeks.append("\u5468\u4e00\uff0c");
                    break;
                }
                case "TUE": {
                    weeks.append("\u5468\u4e8c\uff0c");
                    break;
                }
                case "WED": {
                    weeks.append("\u5468\u4e09\uff0c");
                    break;
                }
                case "THU": {
                    weeks.append("\u5468\u56db\uff0c");
                    break;
                }
                case "FRI": {
                    weeks.append("\u5468\u4e94\uff0c");
                    break;
                }
                case "SAT": {
                    weeks.append("\u5468\u516d\uff0c");
                    break;
                }
                case "SUN": {
                    weeks.append("\u5468\u65e5\uff0c");
                    break;
                }
            }
        }
        return weeks.toString();
    }

    private static String builddaysLog(String str) throws IOException {
        StringBuilder days = new StringBuilder();
        ArrayNode split = (ArrayNode)JsonUtil.toJsonNode((String)str);
        for (Object object : split) {
            if (!"L".equals(object.toString())) {
                days.append(object + "\u65e5\uff0c");
                continue;
            }
            days.append("\u6700\u540e\u4e00\u5929\uff0c");
        }
        return days.toString();
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getDbCronByCode(String code) throws IOException {
        String cron = "";
        PropertiesDao propertiesDao = (PropertiesDao)AppUtil.getBean(PropertiesDao.class);
        Properties properties = propertiesDao.getByCode(code);
        if (BeanUtils.isNotEmpty((Object)properties)) {
            cron = OrgUtil.getScheduledCron(properties.getValue());
        }
        return cron;
    }

    public static void dealRepeatAuthRoot(List<Org> list) {
        if (BeanUtils.isNotEmpty(list) && list.size() > 1) {
            for (int i = 0; i < list.size() - 1; ++i) {
                for (int j = list.size() - 1; j > i; --j) {
                    String iPath;
                    String jPath = list.get(j).getPath();
                    if (jPath.startsWith(iPath = list.get(i).getPath())) {
                        list.remove(j);
                        continue;
                    }
                    if (!iPath.startsWith(jPath)) continue;
                    list.remove(i);
                }
            }
        }
    }
}

