package com.artfess.portal.ueditor;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.file.util.AppFileUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.ueditor.define.AppInfo;
import com.artfess.ueditor.define.BaseState;
import com.artfess.ueditor.define.State;
import com.artfess.ueditor.upload.StorageService;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@Service
@Primary
public class StorageServiceFileImpl implements StorageService {
    @Resource
    FileManager fileManager;

    private String baseDomain;

    @Override
    public State saveBinaryFile(byte[] data, String path) {
        // TODO Auto-generated method stub
        return null;
    }

    // 根据上传时的请求地址 提取路径
    private void buildBaseDomain() {
        if (StringUtil.isNotEmpty(baseDomain)) {
            return;
        }
        Throwable error = null;
        HttpServletRequest request = HttpUtil.getRequest();
        String requestURL = request.getRequestURL().toString();
        try {
            Pattern regex = Pattern.compile("^(.*?)/ueditor/upload$");
            Matcher regexMatcher = regex.matcher(requestURL);
            if (regexMatcher.find()) {
                baseDomain = regexMatcher.group(1);
            }
        } catch (PatternSyntaxException ex) {
            error = ex;
        }
        if (error != null || StringUtil.isEmpty(baseDomain)) {
            throw new BaseException("获取ueditor的上传地址时出错");
        }
    }

    @Override
    public State saveFileByInputStream(InputStream is, String fileName) {
        Assert.isTrue(StringUtil.isNotEmpty(fileName), "上传图片时path不能为空");
        buildBaseDomain();
        DefaultFile file = new DefaultFile();
        IUser currentUser = ContextUtil.getCurrentUser();
        if (currentUser != null) {
            file.setCreateBy(currentUser.getUserId());
            file.setCreatorName(currentUser.getFullname());
        } else {
            file.setCreatorName(DefaultFile.FILE_UPLOAD_UNKNOWN);
        }
        file.setFileName(fileName.lastIndexOf('.') == -1 ? fileName : fileName.substring(0, fileName.lastIndexOf('.')));
        String sysPath = AppFileUtil.getAttachPath();
        String filePath = AppFileUtil.createFilePath("ueditor", fileName);
        filePath = filePath.replace(sysPath + File.separator, "");
        file.setFilePath(filePath);
        // 上传时间
        file.setCreateTime(LocalDateTime.now());
        String extName = FileUtil.getFileExt(fileName);
        // 扩展名
        file.setExtensionName(extName);
        String saveType = AppFileUtil.getSaveType("");
        file.setStoreType(saveType);
        try {
            fileManager.uploadFile(file, is);
            State state = new BaseState(true);
            state.putInfo("title", fileName);
            state.putInfo("url", String.format("%s/file/v1/downloadFile?fileId=%s", baseDomain, file.getId()));
            return state;
        } catch (Exception e) {
            State state = new BaseState(false, AppInfo.IO_ERROR);
            state.putInfo("code", e.getClass().getCanonicalName());
            state.putInfo("message", e.getMessage());
            return state;
        }
    }
}
