package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.portal.model.PortalDataSensitive;
import com.artfess.portal.persistence.dao.PortalDataSensitiveDao;
import com.artfess.portal.persistence.manager.PortalDataSensitiveManager;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <pre>
 * 描述：表字段脱敏处理 处理实现类
 * 构建组：x7
 * 作者:heyf
 * 邮箱:heyf@jee-soft.cn
 * 日期:2020-07-27 16:01:10
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("portalDataSensitiveManager")
public class PortalDataSensitiveManagerImpl extends BaseManagerImpl<PortalDataSensitiveDao, PortalDataSensitive> implements PortalDataSensitiveManager {

    @Resource
    DatabaseContext databaseContext;

    @Override
    @Cacheable(value = CacheKeyConst.EIP_SYS_DATA_SENSITIVE, key = "#root.args[1].toLowerCase()")
    public PortalDataSensitive getByDsNameAndTableName(String dataSourceAlias, String tableName) {
        try (DatabaseSwitchResult setDataSource = databaseContext.setDataSource("master")) {
            return baseMapper.getByDsNameAndTableName(dataSourceAlias, tableName);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
