package com.artfess.portal.controller;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.constants.WebsocketConst;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.webSocket.PushService;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import okhttp3.WebSocket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;

/**
 * @Program: edp
 * @Date: 2021/3/5
 * @Author: ZQF
 * @Description: 系统字典详情
 */
@RestController
@RequestMapping("/sys/sysDictionaryDetail/v1")
@Api(tags = "系统字典详情")
@ApiGroup(group = {ApiGroupConsts.GROUP_SYSTEM})
public class SysDictionaryDetailController extends BaseController<SysDictionaryDetailManager, SysDictionaryDetail> {

    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;

    @Autowired
    PushService pushService;

    @RequestMapping(value = "querySysDictionaryDetail", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "查询字典项列表", httpMethod = "POST", notes = "查询字典项列表")
    public List<SysDictionaryDetail> querySysDictionaryDetail(@ApiParam(name = "sysDictionaryDetail", value = "通用查询对象") @RequestBody SysDictionaryDetail sysDictionaryDetail) throws Exception {
        return sysDictionaryDetailManager.querySysDictionaryDetail(sysDictionaryDetail);
    }

    @RequestMapping(value = "deleteDictionaryDetails", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量删除", httpMethod = "POST", notes = "批量删除")
    public CommonResult<String> deleteDictionaryDetails(@ApiParam(name = "ids", value = "Id集合，以,隔开") @RequestParam String ids) throws Exception {
        sysDictionaryDetailManager.deleteDictionaryDetails(ids);


        HashMap<String, String> map = new HashMap<>();
        map.put(WebsocketConst.MSG_CMD, WebsocketConst.CMD_DICT);
        JSON parse = JSONUtil.parse(map);
        pushService.pushMsgToAll(parse.toString());
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "updateDictionariesDetailsStatus", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改字典明细状态", httpMethod = "POST", notes = "批量修改字典明细状态")
    public CommonResult<String> updateDictionariesDetailsStatus(@ApiParam(name = "ids", value = "Id集合，以,隔开") @RequestParam String ids,
                                                                @ApiParam(name = "status", value = "状态") @RequestParam Integer status) throws Exception {
        sysDictionaryDetailManager.updateDictionariesDetailsStatus(ids, status);
        HashMap<String, String> map = new HashMap<>();
        map.put(WebsocketConst.MSG_CMD, WebsocketConst.CMD_DICT);
        JSON parse = JSONUtil.parse(map);
        pushService.pushMsgToAll(parse.toString());
        return new CommonResult<>(true, "修改成功");
    }

    @RequestMapping(value = "updateDictionariesDetailsSequence", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改字典明细排序号", httpMethod = "POST", notes = "修改字典明细排序号")
    public CommonResult<String> updateDictionariesDetailsSequence(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        sysDictionaryDetailManager.updateDictionariesDetailsSequence(params);
        return new CommonResult<>(true, "排序完成");
    }

    @RequestMapping(value = "saveDictDetailLowerDetails", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "设置字典项的下级级联字典项", httpMethod = "POST", notes = "设置字典项的下级级联字典项")
    public CommonResult<String> saveDictDetailLowerDetails(@ApiParam(name = "detailId", value = "上级字典项id") @RequestParam String detailId,
                                                           @ApiParam(name = "lowerDictId", value = "关联的字典id") @RequestParam String lowerDictId,
                                                           @ApiParam(name = "lowerDetailIds", value = "关联的字典项ids，多个以,隔离") @RequestParam String lowerDetailIds) throws Exception {
        sysDictionaryDetailManager.saveDictDetailLowerDetails(detailId, lowerDictId, lowerDetailIds);
        HashMap<String, String> map = new HashMap<>();
        map.put(WebsocketConst.MSG_CMD, WebsocketConst.CMD_DICT);
        JSON parse = JSONUtil.parse(map);
        pushService.pushMsgToAll(parse.toString());
        return new CommonResult<>(true, "设置成功");
    }

    @RequestMapping(value = "delLowerDetails", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "取消字典项的下级级联字典项", httpMethod = "POST", notes = "取消字典项的下级级联字典项")
    public CommonResult<String> delLowerDetails(@ApiParam(name = "detailId", value = "上级字典项id") @RequestParam String detailId,
                                                @ApiParam(name = "lowerDetailIds", value = "关联的字典项ids，多个以,隔离") @RequestParam String lowerDetailIds) throws Exception {
        sysDictionaryDetailManager.delLowerDetails(detailId, lowerDetailIds);
        HashMap<String, String> map = new HashMap<>();
        map.put(WebsocketConst.MSG_CMD, WebsocketConst.CMD_DICT);
        JSON parse = JSONUtil.parse(map);
        pushService.pushMsgToAll(parse.toString());
        return new CommonResult<>(true, "设置成功");
    }

}
