/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.manager.SysRoleAuthManager;
import com.artfess.sysConfig.persistence.model.SysRoleAuth;
import com.artfess.sysConfig.persistence.param.SysRoleAuthParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/sysRoleAuth/v1"})
@Api(tags={"\u89d2\u8272\u6388\u6743"})
@ApiGroup(group={"group_system"})
public class SysRoleAuthController
extends BaseController<SysRoleAuthManager, SysRoleAuth> {
    @Resource
    SysRoleAuthManager sysRoleAuthManager;

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u6388\u6743\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u89d2\u8272\u6388\u6743\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysRoleAuthParam", value="\u89d2\u8272\u6388\u6743", required=true) @RequestBody SysRoleAuthParam sysRoleAuthParam) throws Exception {
        String resultMsg = null;
        this.sysRoleAuthManager.create(sysRoleAuthParam);
        resultMsg = "\u89d2\u8272\u6388\u6743\u6210\u529f";
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"saveRoleMethods"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u63a5\u53e3\u6388\u6743\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u89d2\u8272\u63a5\u53e3\u6388\u6743\u4fe1\u606f")
    public CommonResult<String> saveRoleMethods(@ApiParam(name="sysRoleAuthParam", value="\u89d2\u8272\u6388\u6743", required=true) @RequestBody SysRoleAuthParam sysRoleAuthParam) throws Exception {
        String resultMsg = null;
        this.sysRoleAuthManager.saveRoleMethods(sysRoleAuthParam);
        resultMsg = "\u89d2\u8272\u6388\u6743\u6210\u529f";
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"getByRoleAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u6388\u6743\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u89d2\u8272\u6388\u6743\u4fe1\u606f")
    @ResponseBody
    public CommonResult<List<SysRoleAuth>> getByRoleAlias(@ApiParam(name="roleAlias", value="\u89d2\u8272\u522b\u540d", required=true) @RequestParam String roleAlias) throws Exception {
        List sysRoleAuthByRoleAlias = this.sysRoleAuthManager.getSysRoleAuthByRoleAlias(roleAlias);
        CommonResult commonResult = new CommonResult();
        commonResult.setValue((Object)sysRoleAuthByRoleAlias);
        return commonResult;
    }

    @RequestMapping(value={"removeRoleMethods"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u89d2\u8272\u63a5\u53e3\u6388\u6743\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u89d2\u8272\u6388\u6743\u8bb0\u5f55a,b,c")
    public CommonResult<String> removeRoleMethods(@ApiParam(name="roleAlias", value="\u89d2\u8272\u522b\u540d", required=true) @RequestParam String roleAlias, @ApiParam(name="methodAlias", value="\u63a5\u53e3\u522b\u540d", required=true) @RequestParam String methodAlias) throws Exception {
        String[] methodAliasArr = StringUtil.getStringAryByStr((String)methodAlias);
        this.sysRoleAuthManager.removeRoleMethods(roleAlias, methodAliasArr);
        return new CommonResult(true, "\u5220\u9664\u89d2\u8272\u63a5\u53e3\u6388\u6743\u6210\u529f");
    }

    @RequestMapping(value={"removeByRoleAlias"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u89d2\u8272\u6388\u6743\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u89d2\u8272\u6388\u6743\u8bb0\u5f55a,b,c")
    public CommonResult<String> removeByRoleAlias(@ApiParam(name="roleAlias", value="\u89d2\u8272\u522b\u540d", required=true) @RequestParam String roleAlias) throws Exception {
        String[] aryroleAlias = StringUtil.getStringAryByStr((String)roleAlias);
        this.sysRoleAuthManager.removeByArrRoleAlias(aryroleAlias);
        return new CommonResult(true, "\u5220\u9664\u89d2\u8272\u6388\u6743\u6210\u529f");
    }

    @RequestMapping(value={"getMethodRoleAuth"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u8ddf\u8bf7\u6c42\u5730\u5740\u7684\u5173\u7cfb", httpMethod="GET", notes="\u83b7\u53d6\u89d2\u8272\u8ddf\u8bf7\u6c42\u5730\u5740\u7684\u5173\u7cfb")
    public List<HashMap<String, String>> getMethodRoleAuth() throws Exception {
        return this.sysRoleAuthManager.getSysRoleAuthAll();
    }

    @RequestMapping(value={"saveCopy"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u6743\u9650\u590d\u5236\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u89d2\u8272\u6743\u9650\u590d\u5236\u4fe1\u606f")
    public CommonResult<String> saveCopy(@ApiParam(name="oldCode", value="\u539f\u89d2\u8272\u522b\u540d", required=true) @RequestParam String oldCode, @ApiParam(name="newCodes", value="\u65b0\u89d2\u8272\u522b\u540d\uff0c\u591a\u4e2a\u9017\u53f7\u9694\u5f00", required=true) @RequestParam String newCodes) throws Exception {
        String resultMsg = null;
        String[] str = newCodes.split(",");
        this.sysRoleAuthManager.createCopy(oldCode, str);
        resultMsg = "\u89d2\u8272\u6743\u9650\u590d\u5236\u6210\u529f";
        return new CommonResult(true, resultMsg);
    }
}

