package com.artfess.sysConfig.persistence.manager;

import com.artfess.base.manager.BaseManager;

import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.sysConfig.persistence.param.DictModel;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 系统字典详情信息
 */
public interface SysDictionaryDetailManager extends BaseManager<SysDictionaryDetail> {

    /**
    * @Description: 批量删除字典明细
    * @Param: ids
    * @Return: void
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    void deleteDictionaryDetails(String ids);

    /**
    * @Description: 批量修改字典明细状态
    * @Param: ids
    * @Param: status
    * @Return: void
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    void updateDictionariesDetailsStatus(String ids, Integer status);

    /**
    * @Description: 修改字典明细排序号
    * @Param: map
    * @Return: void
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    void updateDictionariesDetailsSequence(HashMap<String, Integer> map);

    /**
     * 根据code查询字典明细状态
     * @param code
     * @return
     */
    List<DictModel> queryDictModelItemsByCode(String code, String tenantId);

    /**
     * 根据code查询字典明细状态
     * @param code
     * @return
     */
    List<SysDictionaryDetail> queryDictItemsByCode(@Param("code") String code, String tenantId);

    /**
    * @Description: 获取下一排序号
    * @Param: criteriaMap
    * @Return: java.lang.Integer
    * @Author: ZQF
    * @Date: 2021/3/17
    */
    Integer getNextDetailSequence(Map<String, Object> criteriaMap);

    /**
     * @Description: 设置字典项的下级级联字典项
     * @param detailId 上级字典项id
     * @param lowerDictId 关联的字典id
     * @param lowerDetailIds   关联的字典项IDs，多个以，隔离
     * @Return: void
     * @Author: ZQF
     * @Date: 2021/3/17
     */
    void saveDictDetailLowerDetails(String detailId, String lowerDictId, String lowerDetailIds);

    /**
     * @Description: 取消字典项的下级级联字典项
     * @param detailId 上级字典项id
     * @param lowerDetailIds   关联的字典项IDs，多个以，隔离
     * @Return: void
     * @Author: ZQF
     * @Date: 2021/3/17
     */
    void delLowerDetails(String detailId,String lowerDetailIds);

    /**
    * @Description: 查询字典项
    * @Param: dictionaryId
    * @Return: java.util.List<com.artfess.portal.model.SysDictionaryDetail>
    * @Author: ZQF
    * @Date: 2021/3/18
    */
    List<SysDictionaryDetail> querySysDictionaryDetail(SysDictionaryDetail sysDictionaryDetail);

    /**
    * @Description: 根据字典的编码与值获取中文解释
    * @param code 字典编码
    * @param Val  字典值
    * @Return: java.lang.String
    * @Author: chens
    * @Date: 2023/3/24 10:21
    */
    String getTextByValue(String code,String Val)  throws Exception;
}
