/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.attachmentService;

import cn.hutool.core.util.StrUtil;
import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.config.MinioSetting;
import com.artfess.file.model.FileStorage;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.util.CustomMinioClient;
import com.artfess.file.util.MinioUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListPartsResponse;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MinioAttachmentServiceImpl
implements AttachmentService {
    private static final Logger log = LoggerFactory.getLogger(MinioAttachmentServiceImpl.class);
    @Autowired
    private CustomMinioClient customMinioClient;
    @Autowired
    private MinioSetting minioSetting;

    public String getStoreType() {
        return "minio";
    }

    private MinioSetting initMinioSettings(Attachment attachment, String propertiesId) {
        MinioSetting ossSettings = (MinioSetting)AppUtil.getBean(MinioSetting.class);
        if (StringUtil.isNotEmpty((String)propertiesId)) {
            FileStorageManager fileStorageManager = (FileStorageManager)AppUtil.getBean(FileStorageManager.class);
            FileStorage fileStorage = (FileStorage)fileStorageManager.get((Serializable)((Object)propertiesId));
            if (BeanUtils.isNotEmpty((Object)((Object)fileStorage))) {
                ossSettings.setMinioName(fileStorage.getUserName());
                ossSettings.setMinioPass(fileStorage.getPassword());
                String minioUrl = fileStorage.getUrl();
                if (!minioUrl.startsWith("http")) {
                    minioUrl = "http://" + minioUrl;
                }
                if (!minioUrl.endsWith("/")) {
                    minioUrl = minioUrl.concat("/");
                }
                ossSettings.setMinioUrl(minioUrl);
                ossSettings.setBucketName(fileStorage.getLocation());
                attachment.setEntryptName(Boolean.valueOf(fileStorage.getEncryptName() != 0));
            } else {
                FlowUploadPropertiesManager uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class);
                FlowUploadPropertiesStorageDTO uploadProperties = uploadPropertiesManager.getById(propertiesId);
                if (BeanUtils.isNotEmpty((Object)uploadProperties)) {
                    ossSettings.setMinioName(uploadProperties.getUserName());
                    ossSettings.setMinioPass(uploadProperties.getPassword());
                    String minioUrl = uploadProperties.getUrl();
                    if (!minioUrl.startsWith("http")) {
                        minioUrl = "http://" + minioUrl;
                    }
                    if (!minioUrl.endsWith("/")) {
                        minioUrl = minioUrl.concat("/");
                    }
                    ossSettings.setMinioUrl(minioUrl);
                    ossSettings.setBucketName(uploadProperties.getLocation());
                    attachment.setEntryptName(Boolean.valueOf(uploadProperties.getEncryptName() != 0));
                }
            }
        }
        MinioUtil.setMinioUrl(ossSettings.getMinioUrl());
        MinioUtil.setMinioName(ossSettings.getMinioName());
        MinioUtil.setMinioPass(ossSettings.getMinioPass());
        MinioUtil.setBucketName(ossSettings.getBucketName());
        return ossSettings;
    }

    public void remove(Attachment attachment, String propertiesId) throws Exception {
        String filePath = this.getFilePath(attachment);
        this.initMinioSettings(attachment, propertiesId);
        MinioUtil.removeObject(filePath, true);
    }

    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        String filePath = this.getFilePath(attachment);
        this.initMinioSettings(attachment, propertiesId);
        MinioUtil.uploadByInputStream(inputStream, filePath);
    }

    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        String filePath = this.getFilePath(attachment);
        this.initMinioSettings(attachment, propertiesId);
        MinioUtil.downFile("", filePath, outStream, true);
    }

    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        this.initMinioSettings(attachment, propertiesId);
        return MinioUtil.checkFile("", attachment.getFilePath(), true);
    }

    public byte[] getFileBytes(Attachment sysFile) throws Exception {
        return new byte[0];
    }

    public String getUrl(Attachment attachment) {
        return MinioUtil.getPresignedObjectUrl2upload(attachment.getFilePath());
    }

    public String initMultiPartUpload(Attachment attachment) {
        HashMultimap headers = HashMultimap.create();
        if (StrUtil.isBlank((CharSequence)attachment.getContentType())) {
            headers.put((Object)"Content-Type", (Object)"application/octet-stream");
        }
        String uploadId = null;
        try {
            uploadId = this.customMinioClient.initMultiPartUpload(attachment.getBucket(), null, attachment.getFilePath(), (Multimap<String, String>)headers, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InsufficientDataException e) {
            e.printStackTrace();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (XmlParserException e) {
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            e.printStackTrace();
        }
        catch (ErrorResponseException e) {
            e.printStackTrace();
        }
        return uploadId;
    }

    public String getChunkUrl(Attachment attachment, Integer partNumber, String uploadId) {
        try {
            HashMap<String, String> reqParams = new HashMap<String, String>();
            reqParams.put("partNumber", String.valueOf(partNumber));
            reqParams.put("uploadId", uploadId);
            if (StringUtil.isEmpty((String)attachment.getBucket())) {
                attachment.setBucket(this.minioSetting.getBucketName());
            }
            String uploadUrl = this.customMinioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.PUT).bucket(attachment.getBucket())).object(attachment.getFilePath())).expiry(1, TimeUnit.DAYS).extraQueryParams(reqParams)).build());
            return uploadUrl;
        }
        catch (ErrorResponseException e) {
            e.printStackTrace();
        }
        catch (InsufficientDataException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidResponseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (XmlParserException e) {
            e.printStackTrace();
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean mergeMultipartUpload(Attachment attachment, String uploadId, int realyPartNumber) {
        Integer maxPart = 1000;
        Part[] parts = new Part[maxPart.intValue()];
        ListPartsResponse partResult = null;
        try {
            partResult = this.customMinioClient.listMultipart(null, null, attachment.getFilePath(), maxPart, 0, uploadId, null, null);
            int partNumber = 1;
            for (Part part : partResult.result().partList()) {
                parts[partNumber - 1] = new Part(partNumber, part.etag());
                ++partNumber;
            }
            Integer completedPartCount = partResult.result().partList().size();
            if (completedPartCount < realyPartNumber) {
                log.info(">>>>>>>>>>{}\u5206\u7247\u6587\u4ef6\u4e0d\u591f\uff0c\u4e0d\u80fd\u5408\u5e76", (Object)uploadId);
                throw new BaseException("\u5206\u7247\u6587\u4ef6\u4e0d\u591f\uff0c\u4e0d\u80fd\u5408\u5e76\uff01");
            }
            this.customMinioClient.mergeMultipartUpload(null, null, attachment.getFilePath(), uploadId, parts, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getFilePath(Attachment attachment) {
        String[] split;
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath) && null != (split = filePath.split("/")) && split.length > 1) {
            fileParentPath = Paths.get(filePath, new String[0]).getParent().toString();
            if ((fileParentPath = fileParentPath.replaceAll("\\\\", "/")).startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        String file = fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName();
        return file;
    }
}

