package com.artfess.base.feign;

import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.conf.FeignConfig;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.feign.dto.PortalDataSensitive;
import com.artfess.base.feign.impl.SystemConfigFeignServiceFactory;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.http.client.ClientProtocolException;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/**
 * @author liyg
 */
@FeignClient(name = "bpm-systemConfig", fallbackFactory = SystemConfigFeignServiceFactory.class, configuration = FeignConfig.class, primary = false)
public interface SystemConfigFeignService {

    @RequestMapping(value = "/sys/sysRoleAuth/v1/getMethodRoleAuth", method = RequestMethod.GET)
    public List<HashMap<String, String>> getMethodRoleAuth();

    @RequestMapping(value = "/sys/sysProperties/v1/getByAlias", method = RequestMethod.GET)
    public String getPropertyByAlias(@RequestParam(value = "alias", required = true) String alias);

    @RequestMapping(value = "/sys/sysProperties/v1/getByAlias", method = RequestMethod.GET)
    @Cacheable(value = CacheKeyConst.EIP_SYS_PROPS, key = "#alias")
    public String getByAlias(@RequestParam(value = "alias", required = true) String alias,
                             @RequestParam(value = "defaultValue", required = true) String defaultValue);

    /**
     * 根据别名获取系统分类
     */
    @RequestMapping(value = "/sys/sysType/v1/getJson", method = RequestMethod.GET)
    public ObjectNode getSysTypeById(@RequestParam(value = "id", required = true) String id);

    /**
     * 根据别名和租户ID获取系统分类
     */
    @RequestMapping(value = "/sys/sysType/v1/getJson", method = RequestMethod.GET)
    public ObjectNode getSysTypeById(@RequestParam(value = "id", required = true) String id, @RequestParam(value = "tenantId", required = true) String tenantId);

    /**
     * 根据queryFilter获取系统分类。不带分页
     */
    @RequestMapping(value = "/sys/sysType/v1/list", method = RequestMethod.POST)
    public ObjectNode getAllSysType(@RequestBody(required = true) QueryFilter queryFilter);

    /**
     * 根据用户，指定工时，指定开始时间,计算任务实际完成时间
     * param userId		用户ID
     * param startTime		开始时间
     * param time			工时(分钟)
     *
     * @throws Exception
     * @return 完成时间
     */
    @RequestMapping(value = "/portal/calendar/v1/getEndTimeByUser", method = RequestMethod.POST)
    public String getEndTimeByUser(@RequestBody(required = true) ObjectNode param);

    /**
     * 根据用户开始时间和结束时间，获取这段时间的有效工时
     *
     * @param param
     * @return
     * @throws ClientProtocolException
     * @throws IOException
     */
    @RequestMapping(value = "/portal/calendar/v1/getWorkTimeByUser", method = RequestMethod.POST)
    public Long getWorkTimeByUser(@RequestBody(required = true) ObjectNode param);

    /**
     * 根据数据源别名，获取数据源的设置信息
     *
     * @param alias
     * @return
     */
    @RequestMapping(value = "/sys/sysDataSource/v1/getBeanByAlias", method = RequestMethod.GET)
    public JsonNode getBeanByAlias(@RequestParam(value = "alias", required = true) String alias);

    /**
     * 根据流水号别名获取下一个流水号
     *
     * @param alias
     * @return
     */
    @RequestMapping(value = "/sys/identity/v1/getNextIdByAlias", method = RequestMethod.GET)
    public String getNextIdByAlias(@RequestParam(value = "alias", required = true) String alias);

    /**
     * 根据queryFilter获取新闻公告
     */
    @RequestMapping(value = "/portal/messageNews/v1/list", method = RequestMethod.POST)
    public ObjectNode getMessageNews(@RequestBody(required = true) JsonNode queryFilter);

    /**
     * 根据新闻公告id发布新闻公告
     */
    @RequestMapping(value = "/portal/messageNews/v1/publicMsgNews", method = RequestMethod.POST)
    public ObjectNode publicMsgNews(@RequestBody(required = true) String array);

    /**
     * 根据权限数据判断当前人是否有权限
     *
     * @param permssionJson
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/sys/authUser/v1/calcPermssion", method = RequestMethod.GET)
    public boolean calcPermssion(@RequestParam(value = "permssionJson", required = true) String permssionJson);

    /**
     * 根据权限数据判断当前人是否有权限
     *
     * @param permssionJson
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/sys/authUser/v1/calcAllPermssion", method = RequestMethod.GET)
    public ObjectNode calcAllPermssion(@RequestParam(value = "permssionJson", required = true) String permssionJson);

    @RequestMapping(value = "sys/authUser/v1/getAuthorizeIdsByUserMap", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    public List<String> getAuthorizeIdsByUserMap(@RequestParam(value = "objType", required = true) String objType);

    /**
     * 创建租户时 初始化租户数据
     *
     * @param tenantId
     * @return
     */
    @RequestMapping(value = "/portal/tenantInitData/v1/initData", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    public CommonResult<String> initData(@RequestParam(value = "tenantId", required = true) String tenantId);

    @RequestMapping(value = "/file/v1/wordPrint", method = RequestMethod.POST)
    public String wordPrint(@RequestBody ObjectNode objectNode);

    @RequestMapping(value = "/file/v1/getFileBytesById", method = RequestMethod.GET)
    public byte[] getFileBytesById(@RequestParam(value = "fileId", required = true) String fileId);


    @RequestMapping(value = "/portal/portalDataSensitive/v1/getByDsNameAndTableName", method = RequestMethod.GET)
    @Cacheable(value = CacheKeyConst.EIP_SYS_DATA_SENSITIVE, key = "#root.args[1].toLowerCase()")
    public CommonResult<PortalDataSensitive> getPortalDataSensitive(@RequestParam(value = "dataSourceAlias", required = false) String dataSourceAlias, @RequestParam(value = "tableName", required = true) String tableName);


    /**
     * 根据组别名和分类别名获取系统分类
     */
    @RequestMapping(value = "/sys/sysType/v1/getSysTypeByType", method = RequestMethod.GET)
    public ObjectNode getSysTypeByType(@RequestParam(value = "group", required = true) String group, @RequestParam(value = "typeKey", required = true) String typeKey);

    /**
     * 根据角色别名删除角色菜单授权控制
     * @param roleAlias
     * @return
     */
    @RequestMapping(value="/sys/sysRoleAuth/v1/removeByRoleAlias",method=RequestMethod.DELETE)
    public ObjectNode removeByRoleAlias(@RequestParam(value="roleAlias", required = true) String roleAlias);

    /**
     *
     */
    @RequestMapping(value = "/portal/commonBasic/v1/getOne", method = RequestMethod.GET)
    public ObjectNode getCommonBasicOne();
}
