package com.artfess.gyl.thirdParty.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购会员费用核算表
 *
 * @author huqi
 * @since 2025-11-25
 */
@Data
@TableName("biz_sc_member_calculate")
@ApiModel(value="BizScMemberCalculate对象", description="采购会员费用核算表")
public class BizScMemberCalculate extends BizDelModel<BizScMemberCalculate> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "公司编号")
    @TableField("ORG_CODE_")
    private String orgCode;

    @ApiModelProperty(value = "公司名称")
    @TableField("ORG_NAME_")
    private String orgName;

    @ApiModelProperty(value = "年份")
    @TableField("YEAR_")
    private Integer year;

    @ApiModelProperty(value = "核算时间")
    @TableField("DATE_")
    private LocalDateTime date;

    @ApiModelProperty(value = "年度交易额（采购订单）")
    @TableField("ANNUAL_TRANS_AMOUNT_")
    private BigDecimal annualTransAmount;

    @ApiModelProperty(value = "上年结余金额（上年余额）")
    @TableField("LAST_YEAR_BALANCE_")
    private BigDecimal lastYearBalance;

    @ApiModelProperty(value = "本年入账金额（本年支付会员费金额）")
    @TableField("ENTRY_AMOUNT_")
    private BigDecimal entryAmount;

    @ApiModelProperty(value = "本年支出金额（本年交易额对应的会员费用）")
    @TableField("EXPEND_AMOUNT_")
    private BigDecimal expendAmount;

    @ApiModelProperty(value = "本年余额（本年入账-本年支出）")
    @TableField("BALANCE_")
    private BigDecimal balance;

    @ApiModelProperty(value = "转结状态（1：未转结，2：转结中，3：已转结，默认1）")
    @TableField("UNLOAD_STATUS_")
    private Integer unloadStatus;

    @ApiModelProperty(value = "公司名称")
    @TableField(exist = false)
    private String companyName;
}
