package com.artfess.gyl.thirdParty.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.artfess.gyl.thirdParty.model.BizScMemberCalculate;
import com.artfess.gyl.thirdParty.dao.BizScMemberCalculateDao;
import com.artfess.gyl.thirdParty.manager.BizScMemberCalculateManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.utils.OrgUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 采购会员费用核算表 服务实现类
 *
 * @author huqi
 * @since 2025-11-25
 */
@Service
public class BizScMemberCalculateManagerImpl extends BaseManagerImpl<BizScMemberCalculateDao, BizScMemberCalculate> implements BizScMemberCalculateManager {

    @Autowired
    private UCFeignService ucFeignService;

    @Autowired
    private BizEnterpriseManager enterpriseManager;

    @Override
    public JSONObject queryByOrg(QueryFilter<BizScMemberCalculate> queryFilter,String orgId) {
        JSONObject object = new JSONObject();
        QueryWrapper<BizScMemberCalculate> wrapper = new QueryWrapper<>();
        wrapper.eq("ORG_ID_", orgId);
        wrapper.select("SUM(ANNUAL_TRANS_AMOUNT_) as totalAnnualTransAmount");
        Map<String, Object> resultMap = super.getMap(wrapper);
        BigDecimal totalPrice = BigDecimal.ZERO;
        if (resultMap != null && resultMap.get("totalAnnualTransAmount") != null) {
            Object total = resultMap.get("totalAnnualTransAmount");
            if (total instanceof BigDecimal) {
                totalPrice = (BigDecimal) total;
            } else if (total instanceof Double) {
                totalPrice = BigDecimal.valueOf((Double) total);
            } else if (total instanceof Long) {
                totalPrice = BigDecimal.valueOf((Long) total);
            }
        }

        object.put("totalPrice", totalPrice);
        //分页数据查询
        queryFilter.addFilter("ORG_ID_",orgId,QueryOP.EQUAL);
        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        IPage<BizScMemberCalculate> result = baseMapper.queryOrderByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        object.put("data",new PageList<>(result));
        return object;
    }
}
