package com.artfess.gyl.thirdParty.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.base.manager.BizSupplierMaterialCategoryManager;
import com.artfess.gyl.base.model.BizSupplierMaterialCategory;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.thirdParty.model.BizCategory;
import com.artfess.gyl.thirdParty.dao.BizCategoryDao;
import com.artfess.gyl.thirdParty.manager.BizCategoryManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.thirdParty.vo.CategoryNumVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 *  服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-10
 */
@Service
public class BizCategoryManagerImpl extends BaseManagerImpl<BizCategoryDao, BizCategory> implements BizCategoryManager {
    @Resource
    private BizSupplierMaterialCategoryManager categoryManager;

    @Override
    public List<BizCategory> tree(QueryFilter<BizCategory> queryFilter) {
        IPage<BizCategory> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        List<BizCategory> records = iPage.getRecords();
        if (records != null && records.size()>0) {
            List<BizCategory> collect = records.stream().filter(category -> category.getCatPid().equals("0")).collect(Collectors.toList());
            for (BizCategory c : collect) {
                c.setChildren(getchildren(c, records));
            }
            return collect;
        }
        return new ArrayList();
    }

    @Override
    public List<CategoryNumVo> countByType(QueryFilter<BizCategory> queryFilter) {
        ArrayList<CategoryNumVo> dataList = new ArrayList<>();
        List<BizSupplierMaterialCategory> categories = categoryManager.list(
                new LambdaQueryWrapper<BizSupplierMaterialCategory>()
                        .eq(BizSupplierMaterialCategory::getStatus, 1)
                        .orderByAsc(BizSupplierMaterialCategory::getSeq,
                                BizSupplierMaterialCategory::getCreateTime)
        );
        IPage<BizCategory> iPage = baseMapper.queryByPage(
                convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass())
        );
        List<BizCategory> records = iPage.getRecords();

        // 汇总统计
        dataList.add(new CategoryNumVo("总数", records.size()));

       // 根据分类统计
        List<BizCategory> fiterList = records.stream().filter(category -> category.getCategoryId() != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(fiterList) && !CollectionUtils.isEmpty(categories)) {
            // 构建分类ID映射，便于快速查找
            Map<String, String> categoryMap = categories.stream()
                    .collect(Collectors.toMap(BizSupplierMaterialCategory::getId,
                            BizSupplierMaterialCategory::getName));

            // 使用Map进行计数统计
            Map<String, Integer> countMap = new HashMap<>();
            for (String categoryId : categoryMap.keySet()) {
              for (BizCategory item : fiterList) {
                    if (item.getCategoryId().contains(categoryId)) {
                        countMap.put(categoryId, countMap.getOrDefault(categoryId, 0) + 1);
                    }
                }
            }

            // 构建结果对象
            countMap.forEach((categoryId, count) -> {
                    dataList.add(new CategoryNumVo(categoryId, categoryMap.get(categoryId), count));
            });
        }

        return dataList;
    }

    @Override
    public List<BizCategory> queryUnconfiguredTree(QueryFilter<BizCategory> queryFilter) {
        IPage<BizCategory> iPage = baseMapper.queryUnconfigured(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        List<BizCategory> records = iPage.getRecords();
        if (records != null && records.size()>0) {
            List<BizCategory> collect = records.stream().filter(category -> category.getCatPid().equals("0")).collect(Collectors.toList());
            for (BizCategory c : collect) {
                c.setChildren(getchildren(c, records));
            }
            return collect;
        }
        return new ArrayList();
    }

    private List<BizCategory> getchildren(BizCategory root, List<BizCategory> list) {
        List<BizCategory> children = list.stream().filter(category -> category.getCatPid().equals(root.getId())
        ).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(children) && children.size() > 0) {
            for (BizCategory c : children) {
                c.setChildren(getchildren(c, list));
            }
        }
        return children;
    }
}
