package com.artfess.gyl.thirdParty.controller;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.utils.HttpUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

@RestController
@Api(tags = "对外接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
@RequestMapping("api")
public class ForeignApiController {

    @Value("${zsj.checkTokenKeyUrl}")
    private String checkTokenKeyUrl;
    @Value("${zsj.getUserByTokenUrl}")
    private String getUserByTokenUrl;

    @PostMapping("/valid/{tokenKey}")
    @ApiOperation(value = "M-调用门户网站校验tokenKey", httpMethod = "POST")
    public CommonResult validTokenKey(@PathVariable String tokenKey) throws Exception {
        if(BeanUtils.isEmpty(tokenKey)) {
            return new CommonResult(false,"tokenKey不能为空");
        }

        //校验tokenKey并拿到token
        Map<String,Object> map = new HashMap<>();
        map.put("tokenKey",tokenKey);
        String token = HttpUtil.get(checkTokenKeyUrl,map);

        System.out.println(LocalDateTime.now()+"获取token结果："+token);
        if(BeanUtils.isEmpty(token)){
            throw new BaseException("登录超时，请重新登录后跳转");
        }

        JSONObject jsonObject = JSON.parseObject(token);
        Object value = jsonObject.get("value");
        if(BeanUtils.isEmpty(value)) {
            return new CommonResult(false,"无效的token");
        }

        //根据token获取用户信息
        Map<String,String> tokenMap = new HashMap<>();
        tokenMap.put("Authorization","Bearer "+value);
        String userInfo = HttpUtils.post(getUserByTokenUrl,null,tokenMap,"application/json",3000,3000,"UTF-8");

        System.out.println(LocalDateTime.now()+"根据token获取用户信息结果："+userInfo);
        JSONObject userJsonObject = JSON.parseObject(userInfo);
        Object resultObj = userJsonObject.get("value");
        if(BeanUtils.isEmpty(resultObj)) {
            return new CommonResult<>(false,"无效的token");
        }
        JSONObject result = JSON.parseObject(resultObj.toString());

        return new CommonResult<>(true,"操作成功",result);
    }

}
