package com.artfess.gyl.thirdParty.controller;


import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.thirdParty.model.BizScMemberCalculate;
import com.artfess.gyl.thirdParty.manager.BizScMemberCalculateManager;

import javax.annotation.Resource;

/**
 * 采购会员费用核算表 前端控制器
 *
 * @author huqi
 * @since 2025-11-25
 */
@RestController
@RequestMapping("/bizScMemberCalculate/v1/")
@Api(tags = "第三方数据-采购记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizScMemberCalculateController extends BaseController<BizScMemberCalculateManager, BizScMemberCalculate> {

    @Resource
    private BizEnterpriseManager enterpriseManager;

    @PostMapping("/queryCurOrg")
    @ApiOperation(value = "M-分页查询当前公司数据",notes = "参数说明：在通用查询器中的query对象组传入查询参数",httpMethod = "POST")
    public PageList<BizScMemberCalculate> queryCurOrg(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<BizScMemberCalculate> queryFilter) {
        IGroup org = ContextUtil.getCurrentGroup();
        BizEnterprise enterprise = enterpriseManager.getByOrgIdOrCode(org.getGroupId(),org.getGroupCode());
        queryFilter.addFilter("ORG_CODE_", org.getGroupCode(), QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
        if(BeanUtils.isNotEmpty(enterprise) && BeanUtils.isNotEmpty(enterprise.getHistoryCompanyCode())) {
            queryFilter.addFilter("ORG_CODE_", enterprise.getHistoryCompanyCode(), QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
        }
        return baseService.query(queryFilter);
    }


    @PostMapping("/queryByOrg")
    @ApiOperation(value = "M-分页查询当前公司数据（管理员查看所有）",notes = "参数说明：在通用查询器中的query对象组传入查询参数",httpMethod = "POST")
    public CommonResult<JSONObject> queryByOrg(@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<BizScMemberCalculate> queryFilter,
                                               @RequestParam("orgId") String orgId) {
        JSONObject result = baseService.queryByOrg(queryFilter, orgId);
        return new CommonResult<>(true,"查询成功",result);
    }

}
