package com.artfess.gyl.supplierEva.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核评价表
 *
 * @author huqi
 * @since 2025-11-27
 */
@Data
@ApiModel(value="BizSupplierPerformanceEvaluationResult对象", description="供应商绩效考核评价表")
public class BizSupplierPerformanceEvaluationResult extends BaseModel<BizSupplierPerformanceEvaluationResult> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "绩效考核配置ID")
    @TableField("VALUATION_CONFIGURATION_ID_")
    private String valuationConfigurationId;

    @ApiModelProperty(value = "绩效考核配置CODE")
    @TableField("EVALUATION_ID_")
    private String evaluationId;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "供应商编号")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "总分值")
    @TableField("TOTAL_SCORE_")
    private Integer totalScore;

    @ApiModelProperty(value = "考核得分")
    @TableField("OPERATION_SCORE_")
    private BigDecimal operationScore;

    @ApiModelProperty(value = "等级(1：优秀，2：良好，3：合格，4：可改善，5：不合格)")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "评价结论（1合格，2可改善，3不合格）")
    @TableField("ASSESSMENT_RESULT_")
    private String assessmentResult;

    @ApiModelProperty(value = "处置类型 0.无处置 1.预警 2.限期")
    @TableField("PROCESS_TYPE_")
    private String processType;

    @ApiModelProperty(value = "状态(1：已完成，2：已提交待评分，3评分中，4评分完毕待评价，5取消/关闭)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;
}
