package com.artfess.gyl.supplierEva.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核评分明细表
 *
 * @author huqi
 * @since 2025-11-22
 */
@Data
@TableName("biz_supplier_performance_evaluation_rating_user")
@ApiModel(value="BizSupplierPerformanceEvaluationRatingUser对象", description="供应商绩效考核评分明细表")
public class BizSupplierPerformanceEvaluationRatingUser extends BizDelModel<BizSupplierPerformanceEvaluationRatingUser> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考核评价ID")
    @TableField("PERFORMANCE_EVALUATION_ID_")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "考核评分明细ID")
    @TableField("EVALUATION_RATING_ID_")
    private String evaluationRatingId;

    @ApiModelProperty(value = "分值")
    @TableField("SCORE_")
    private Integer score;

    @ApiModelProperty(value = "评分人ID")
    @TableField("RATING_ID_")
    private String ratingId;

    @ApiModelProperty(value = "评分人ACCOUNT")
    @TableField("RATING_ACCOUNT_")
    private String ratingAccount;

    @ApiModelProperty(value = "评分人")
    @TableField("RATING_NAME_")
    private String ratingName;

    @ApiModelProperty(value = "评分时间")
    @TableField("RATING_TIME_")
    private LocalDateTime ratingTime;

    @ApiModelProperty(value = "得分")
    @TableField("OPERATION_SCORE_")
    private BigDecimal operationScore;

    @ApiModelProperty(value = "状态(1：已完成，0：未完成)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "绩效考核分类NAME")
    @TableField(exist = false)
    private String assessmentIndicatorTypeName;

    @ApiModelProperty(value = "绩效考核分类ID")
    @TableField(exist = false)
    private String assessmentIndicatorTypeId;

    @ApiModelProperty(value = "绩效考核分类CODE")
    @TableField(exist = false)
    private String assessmentIndicatorTypeCode;
    @ApiModelProperty(value = "绩效考核分类id")
    @TableField(exist = false)
    private String performanceEvaluationDetailsId;

    @ApiModelProperty(value = "绩效考核分类Code")
    @TableField(exist = false)
    private String performanceEvaluationDetailsCode;

    @ApiModelProperty(value = "评审内容")
    @TableField(exist = false)
    private String performanceEvaluationDetailsName;
}
